/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.item;

import galena.oreganized.content.entity.MinecartShrapnelBomb;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MinecartShrapnelBombItem
extends MinecartItem {
    public final Supplier<EntityType<MinecartShrapnelBomb>> minecart;
    private final DispenseItemBehavior dispenserBehaviour = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior defaultBehaviour = new DefaultDispenseItemBehavior();

        public ItemStack execute(BlockSource source, ItemStack stack) {
            double yOffset;
            RailShape railShape;
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            ServerLevel level = source.level();
            Vec3 center = source.center();
            double x = center.x() + (double)direction.getStepX() * 1.125;
            double y = Math.floor(center.y()) + (double)direction.getStepY();
            double z = center.z() + (double)direction.getStepZ() * 1.125;
            BlockPos pos = source.pos().relative(direction);
            BlockState state = level.getBlockState(pos);
            RailShape railShape2 = railShape = state.getBlock() instanceof BaseRailBlock ? (RailShape)state.getValue(((BaseRailBlock)state.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
            if (state.is(BlockTags.RAILS)) {
                yOffset = railShape.isAscending() ? 0.6 : 0.1;
            } else {
                if (!state.isAir() || !level.getBlockState(pos.below()).is(BlockTags.RAILS)) {
                    return this.defaultBehaviour.dispense(source, stack);
                }
                BlockState belowState = level.getBlockState(pos.below());
                RailShape belowRailShape = belowState.getBlock() instanceof BaseRailBlock ? (RailShape)belowState.getValue(((BaseRailBlock)belowState.getBlock()).getShapeProperty()) : RailShape.NORTH_SOUTH;
                yOffset = direction != Direction.DOWN && belowRailShape.isAscending() ? -0.4 : -0.9;
            }
            AbstractMinecart minecart = MinecartShrapnelBombItem.this.createMinecart((Level)level, x, y + yOffset, z);
            if (minecart == null) {
                return stack;
            }
            EntityType.createDefaultStackConfig((ServerLevel)level, (ItemStack)stack, null).accept(minecart);
            level.addFreshEntity((Entity)minecart);
            stack.shrink(1);
            return stack;
        }
    };

    public MinecartShrapnelBombItem(AbstractMinecart.Type base, Supplier<EntityType<MinecartShrapnelBomb>> minecart) {
        super(base, new Item.Properties().stacksTo(1));
        this.minecart = minecart;
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)this.dispenserBehaviour);
    }

    private AbstractMinecart createMinecart(Level level, double x, double y, double z) {
        MinecartShrapnelBomb minecart = (MinecartShrapnelBomb)this.minecart.get().create(level);
        if (minecart == null) {
            return null;
        }
        minecart.setPos(x, y, z);
        minecart.xo = x;
        minecart.yo = y;
        minecart.zo = z;
        return minecart;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockpos;
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(blockpos = context.getClickedPos());
        if (!blockstate.is(BlockTags.RAILS)) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        if (!level.isClientSide) {
            RailShape railshape = blockstate.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)level, blockpos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.isAscending()) {
                d0 = 0.5;
            }
            AbstractMinecart minecart = this.createMinecart(level, (double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.0625 + d0, (double)blockpos.getZ() + 0.5);
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                minecart.setCustomName(stack.getHoverName());
            }
            level.addFreshEntity((Entity)minecart);
            level.gameEvent((Holder)GameEvent.ENTITY_PLACE, blockpos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)level.getBlockState(blockpos.below())));
        }
        stack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void playSound(BlockSource source) {
        source.level().levelEvent(1000, source.pos(), 0);
    }
}

