/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.item;

import galena.oreganized.OreganizedConfig;
import galena.oreganized.content.block.ICrystalGlass;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class ScribeItem
extends Item {
    private static final Map<Block, Supplier<Block>> GROOVED_BLOCKS = new HashMap<Block, Supplier<Block>>();

    public static void registerGroovedBlock(Block from, Supplier<Block> to) {
        GROOVED_BLOCKS.put(from, to);
    }

    public static Set<Map.Entry<Block, Supplier<Block>>> getGroovedBlocks() {
        return GROOVED_BLOCKS.entrySet();
    }

    public ScribeItem(Item.Properties properties) {
        super(properties);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity user) {
        if (!level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            stack.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
        }
        return true;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.is(OTags.Blocks.MINEABLE_WITH_SCRIBE)) {
            return 32.0f;
        }
        if (this.isCorrectToolForDrops(stack, state)) {
            return 0.3f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean dropsLikeSilktouch(ItemStack stack, BlockState state) {
        return this.isCorrectToolForDrops(stack, state) && !this.shouldNotSilktouch(stack, state);
    }

    private boolean shouldNotSilktouch(ItemStack stack, BlockState state) {
        return state.is(OTags.Blocks.SILKTOUCH_WITH_SCRIBE_BLACKLIST);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (((Boolean)OreganizedConfig.COMMON.scribeSilkTouchStone.get()).booleanValue()) {
            return state.is(OTags.Blocks.SILKTOUCH_WITH_SCRIBE);
        }
        return state.is(OTags.Blocks.MINEABLE_WITH_SCRIBE);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairStack) {
        return repairStack.is(Items.AMETHYST_SHARD);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(EnchantmentTags.MINING_EXCLUSIVE)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    private InteractionResult replaceBlock(UseOnContext context, BlockState to, boolean particles) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState from = level.getBlockState(pos);
        level.setBlockAndUpdate(pos, to);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)from));
        if (particles) {
            level.addDestroyBlockEffect(pos, from);
        }
        if (context.getPlayer() != null) {
            context.getPlayer().playSound(SoundEvents.GRINDSTONE_USE, 1.0f, 1.5f);
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)context.getPlayer(), LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.hasProperty((Property)ICrystalGlass.TYPE)) {
            Integer type = (Integer)state.getValue((Property)ICrystalGlass.TYPE);
            return this.replaceBlock(context, (BlockState)state.setValue((Property)ICrystalGlass.TYPE, (Comparable)Integer.valueOf((type + 1) % 4)), true);
        }
        Supplier<Block> grooved = GROOVED_BLOCKS.get(state.getBlock());
        if (grooved != null) {
            return this.replaceBlock(context, grooved.get().defaultBlockState(), true);
        }
        if (state.getBlock() instanceof AmethystClusterBlock && !state.is(Blocks.SMALL_AMETHYST_BUD)) {
            ItemStack tool = new ItemStack((ItemLike)Items.IRON_PICKAXE);
            tool.applyComponents(context.getItemInHand().getComponents());
            Block.dropResources((BlockState)state, (Level)context.getLevel(), (BlockPos)context.getClickedPos(), null, (Entity)context.getPlayer(), (ItemStack)tool);
            return this.replaceBlock(context, Blocks.SMALL_AMETHYST_BUD.withPropertiesOf(state), false);
        }
        return super.useOn(context);
    }

    static {
        ScribeItem.registerGroovedBlock(Blocks.ICE, OBlocks.GROOVED_ICE);
        ScribeItem.registerGroovedBlock(Blocks.PACKED_ICE, OBlocks.GROOVED_PACKED_ICE);
        ScribeItem.registerGroovedBlock(Blocks.BLUE_ICE, OBlocks.GROOVED_BLUE_ICE);
    }
}

