/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data.provider;

import galena.oreganized.data.ConditionalData;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public abstract class OBlockLootProvider
extends BlockLootSubProvider {
    protected OBlockLootProvider(HolderLookup.Provider lookup) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), lookup);
    }

    public void dropSelf(Supplier<? extends Block> block) {
        this.dropSelf(block.get());
    }

    public void slab(Supplier<? extends Block> slab) {
        this.add(slab.get(), x$0 -> this.createSlabItemTable((Block)x$0));
    }

    public void dropOther(Supplier<? extends Block> brokenBlock, ItemLike droppedBlock) {
        this.dropOther(brokenBlock.get(), droppedBlock);
    }

    public void dropAsSilk(Supplier<? extends Block> block) {
        this.dropWhenSilkTouch(block.get());
    }

    public void dropWithSilk(Supplier<? extends Block> block, Supplier<? extends ItemLike> drop) {
        this.add(block.get(), result -> this.createSingleItemTableWithSilkTouch((Block)result, (ItemLike)drop.get()));
    }

    public void ore(Supplier<? extends Block> block, Supplier<? extends Item> drop) {
        this.add(block.get(), result -> this.createOreDrop((Block)result, (Item)drop.get()));
    }

    public void ore(Supplier<? extends Block> block, Item drop) {
        this.add(block.get(), result -> this.createOreDrop((Block)result, drop));
    }

    public void cauldron(Supplier<? extends Block> block) {
        this.dropOther(block, (ItemLike)Blocks.CAULDRON);
    }

    public void dropNothing(Supplier<? extends Block> block) {
        this.dropOther(block, (ItemLike)Blocks.AIR);
    }

    public void dyed(DyeColor color, Runnable block) {
        ConditionalData.dyed(color, this, block);
    }
}

