/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.index;

import com.google.common.collect.ImmutableList;
import galena.oreganized.Oreganized;
import galena.oreganized.index.OBlocks;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.OrePlacements;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.HeightmapPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class OFeatures {

    public static final class Placed {
        public static final ResourceKey<PlacedFeature> SILVER_ORE = Placed.create("silver_ore");
        public static final ResourceKey<PlacedFeature> SILVER_ORE_EXTRA = Placed.create("silver_ore_extra");
        public static final ResourceKey<PlacedFeature> LEAD_ORE = Placed.create("lead_ore");
        public static final ResourceKey<PlacedFeature> LEAD_ORE_EXTRA = Placed.create("lead_ore_extra");
        public static final ResourceKey<PlacedFeature> DATURA = Placed.create("datura");
        public static final ResourceKey<PlacedFeature> PURPLE_DATURA = Placed.create("purple_datura");
        public static final ResourceKey<PlacedFeature> SPARSE_DATURA = Placed.create("sparse_datura");
        public static final ResourceKey<PlacedFeature> SPARSE_PURPLE_DATURA = Placed.create("sparse_purple_datura");

        public static ResourceKey<PlacedFeature> create(String name) {
            return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)Oreganized.modLoc(name));
        }

        public static void bootstrap(BootstrapContext<PlacedFeature> context) {
            HolderGetter features = context.lookup(Registries.CONFIGURED_FEATURE);
            context.register(SILVER_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(Configured.SILVER_ORE), OrePlacements.commonOrePlacement((int)5, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-15), (VerticalAnchor)VerticalAnchor.absolute((int)5)))));
            context.register(SILVER_ORE_EXTRA, (Object)new PlacedFeature((Holder)features.getOrThrow(Configured.SILVER_ORE), OrePlacements.commonOrePlacement((int)5, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)140), (VerticalAnchor)VerticalAnchor.absolute((int)160)))));
            context.register(LEAD_ORE, (Object)new PlacedFeature((Holder)features.getOrThrow(Configured.LEAD_ORE), OrePlacements.commonOrePlacement((int)10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-40), (VerticalAnchor)VerticalAnchor.absolute((int)-20)))));
            context.register(LEAD_ORE_EXTRA, (Object)new PlacedFeature((Holder)features.getOrThrow(Configured.LEAD_ORE), OrePlacements.commonOrePlacement((int)10, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)50), (VerticalAnchor)VerticalAnchor.absolute((int)80)))));
            context.register(DATURA, (Object)new PlacedFeature((Holder)features.getOrThrow(Configured.DATURA), Placed.rareOrePlacement(10, (PlacementModifier)HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES))));
            context.register(PURPLE_DATURA, (Object)new PlacedFeature((Holder)features.getOrThrow(Configured.PURPLE_DATURA), Placed.rareOrePlacement(25, (PlacementModifier)HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES))));
            context.register(SPARSE_DATURA, (Object)new PlacedFeature((Holder)features.getOrThrow(Configured.SPARSE_DATURA), Placed.rareOrePlacement(30, (PlacementModifier)HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES))));
            context.register(SPARSE_PURPLE_DATURA, (Object)new PlacedFeature((Holder)features.getOrThrow(Configured.SPARSE_PURPLE_DATURA), Placed.rareOrePlacement(75, (PlacementModifier)HeightmapPlacement.onHeightmap((Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES))));
        }

        private static List<PlacementModifier> rareOrePlacement(int pChance, PlacementModifier pHeightRange) {
            return Placed.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)pChance), pHeightRange);
        }

        private static List<PlacementModifier> orePlacement(PlacementModifier pCountPlacement, PlacementModifier pHeightRange) {
            return List.of(pCountPlacement, InSquarePlacement.spread(), pHeightRange, BiomeFilter.biome());
        }
    }

    public static final class Configured {
        public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE = Configured.create("silver_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE_EXTRA = Configured.create("silver_ore_extra");
        public static final ResourceKey<ConfiguredFeature<?, ?>> LEAD_ORE = Configured.create("lead_ore");
        public static final ResourceKey<ConfiguredFeature<?, ?>> LEAD_ORE_EXTRA = Configured.create("lead_ore_extra");
        public static final ResourceKey<ConfiguredFeature<?, ?>> DATURA = Configured.create("datura");
        public static final ResourceKey<ConfiguredFeature<?, ?>> PURPLE_DATURA = Configured.create("purple_datura");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SPARSE_DATURA = Configured.create("sparse_datura");
        public static final ResourceKey<ConfiguredFeature<?, ?>> SPARSE_PURPLE_DATURA = Configured.create("sparse_purple_datura");

        public static ResourceKey<ConfiguredFeature<?, ?>> create(String name) {
            return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)Oreganized.modLoc(name));
        }

        public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
            context.register(SILVER_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)((Block)OBlocks.SILVER_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)((Block)OBlocks.DEEPSLATE_SILVER_ORE.get()).defaultBlockState())), 3, 0.8f)));
            context.register(SILVER_ORE_EXTRA, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)((Block)OBlocks.SILVER_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)((Block)OBlocks.DEEPSLATE_SILVER_ORE.get()).defaultBlockState())), 2, 1.0f)));
            context.register(LEAD_ORE, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)((Block)OBlocks.LEAD_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)((Block)OBlocks.DEEPSLATE_LEAD_ORE.get()).defaultBlockState())), 8)));
            context.register(LEAD_ORE_EXTRA, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)((Block)OBlocks.LEAD_ORE.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES), (BlockState)((Block)OBlocks.DEEPSLATE_LEAD_ORE.get()).defaultBlockState())), 8)));
            context.register(DATURA, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)Configured.daturaPatch(false, (Holder<PlacedFeature>)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)OBlocks.WHITE_DATURA.get())))))));
            context.register(PURPLE_DATURA, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)Configured.daturaPatch(false, (Holder<PlacedFeature>)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)OBlocks.PURPLE_DATURA.get())))))));
            context.register(SPARSE_DATURA, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)Configured.daturaPatch(true, (Holder<PlacedFeature>)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)OBlocks.WHITE_DATURA.get())))))));
            context.register(SPARSE_PURPLE_DATURA, (Object)new ConfiguredFeature(Feature.RANDOM_PATCH, (FeatureConfiguration)Configured.daturaPatch(true, (Holder<PlacedFeature>)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)OBlocks.PURPLE_DATURA.get())))))));
        }

        private static RandomPatchConfiguration daturaPatch(boolean sparse, Holder<PlacedFeature> feature) {
            return new RandomPatchConfiguration(64, sparse ? 2 : 4, 3, feature);
        }
    }
}

