/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.world;

import galena.oreganized.index.OTags;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class ScaredOfGargoyleGoal
extends Goal {
    public static final String AVOID_TAG_KEY = "ScaredByGargoyle";
    public static final int MAX_DISTANCE_SQR = 256;
    public static final int SPRINT_DISTANCE_SQR = 49;
    private final PathfinderMob mob;
    @Nullable
    private Path path;
    private final PathNavigation navigation;
    @Nullable
    private Vec3 avoiding;

    public static void addGoal(Entity entity) {
        PathfinderMob mob;
        if (entity instanceof PathfinderMob && (mob = (PathfinderMob)entity).getType().is(OTags.Entities.SCARED_OF_GARGOYLE)) {
            mob.goalSelector.addGoal(1, (Goal)new ScaredOfGargoyleGoal(mob));
        }
    }

    public ScaredOfGargoyleGoal(PathfinderMob mob) {
        this.mob = mob;
        this.navigation = mob.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        CompoundTag data = this.mob.getPersistentData();
        if (!data.contains(AVOID_TAG_KEY)) {
            return false;
        }
        BlockPos toAvoid = NbtUtils.readBlockPos((CompoundTag)data, (String)AVOID_TAG_KEY).orElse(null);
        if (toAvoid == null) {
            return false;
        }
        this.avoiding = Vec3.atCenterOf((Vec3i)toAvoid);
        if (this.mob.distanceToSqr(this.avoiding) > 256.0) {
            return false;
        }
        Vec3 awayPos = DefaultRandomPos.getPosAway((PathfinderMob)this.mob, (int)16, (int)7, (Vec3)this.avoiding);
        if (awayPos == null) {
            return false;
        }
        if (this.avoiding.distanceToSqr(awayPos) < this.mob.distanceToSqr(this.avoiding)) {
            return false;
        }
        this.path = this.navigation.createPath(awayPos.x, awayPos.y, awayPos.z, 0);
        return this.path != null;
    }

    public boolean canContinueToUse() {
        return !this.navigation.isDone();
    }

    public void start() {
        this.navigation.moveTo(this.path, 1.0);
    }

    public void stop() {
        this.avoiding = null;
        this.mob.getPersistentData().remove(AVOID_TAG_KEY);
    }

    public void tick() {
        if (this.avoiding == null) {
            return;
        }
        if (this.mob.distanceToSqr(this.avoiding) < 49.0) {
            this.mob.getNavigation().setSpeedModifier(1.3);
        } else {
            this.mob.getNavigation().setSpeedModifier(1.0);
        }
    }
}

