/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized;

import com.google.common.collect.ImmutableBiMap;
import com.mojang.serialization.Codec;
import com.teamabnormals.blueprint.common.dispenser.FishBucketDispenseItemBehavior;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import galena.oreganized.OreganizedConfig;
import galena.oreganized.api.LeadProtections;
import galena.oreganized.compat.ColorCompat;
import galena.oreganized.compat.create.CreateCompat;
import galena.oreganized.content.block.LeadOreBlock;
import galena.oreganized.content.block.MeltableBlock;
import galena.oreganized.content.block.MoltenLeadCauldronBlock;
import galena.oreganized.content.entity.LeadBoltEntity;
import galena.oreganized.data.OAdvancements;
import galena.oreganized.data.OBiomeTags;
import galena.oreganized.data.OBlockStates;
import galena.oreganized.data.OBlockTags;
import galena.oreganized.data.ODamageTags;
import galena.oreganized.data.OEntityTags;
import galena.oreganized.data.OFluidTags;
import galena.oreganized.data.OItemModels;
import galena.oreganized.data.OItemTags;
import galena.oreganized.data.OLang;
import galena.oreganized.data.OLootTables;
import galena.oreganized.data.OPaintingVariantTags;
import galena.oreganized.data.ORecipes;
import galena.oreganized.data.ORegistries;
import galena.oreganized.data.OSoundDefinitions;
import galena.oreganized.data.OSpriteSourceProvider;
import galena.oreganized.index.OAttributes;
import galena.oreganized.index.OBlockEntities;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OCriteriaTriggers;
import galena.oreganized.index.OEffects;
import galena.oreganized.index.OEntityTypes;
import galena.oreganized.index.OFluids;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OPaintingVariants;
import galena.oreganized.index.OParticleTypes;
import galena.oreganized.index.OPotions;
import galena.oreganized.index.ORecipeTypes;
import galena.oreganized.index.OSoundEvents;
import galena.oreganized.index.OStructures;
import galena.oreganized.index.OTags;
import galena.oreganized.network.OreganizedNetwork;
import galena.oreganized.world.AddItemLootModifier;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.DetectedVersion;
import net.minecraft.core.Position;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="oreganized")
public class Oreganized {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "oreganized";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("oreganized");
    private static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"oreganized");

    public static ResourceLocation modLoc(String location) {
        return new ResourceLocation(MOD_ID, location);
    }

    public Oreganized() {
        IEventBus modBus = (IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        OreganizedConfig.register();
        modBus.addListener(this::setup);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::gatherData);
        forgeBus.addListener(this::injectVillagerTrades);
        LOOT_MODIFIERS.register("add_item", () -> AddItemLootModifier.CODEC);
        OEffects.register(modBus);
        OEntityTypes.register(modBus);
        OFluids.register(modBus);
        OParticleTypes.register(modBus);
        OPotions.register(modBus);
        OStructures.register(modBus);
        OAttributes.register(modBus);
        LOOT_MODIFIERS.register(modBus);
        OBlockEntities.register();
        OBlocks.register();
        OItems.register();
        OCriteriaTriggers.register();
        OSoundEvents.register();
        ORecipeTypes.register(modBus);
        OPaintingVariants.register(modBus);
        REGISTRY_HELPER.register(modBus);
        OreganizedNetwork.register();
        boolean createLoaded = ModList.get().getModContainerById("create").filter(it -> it.getModInfo().getVersion().getMajorVersion() >= 6).isPresent();
        if (createLoaded) {
            CreateCompat.register();
        }
        LeadProtections.register(entity -> entity.m_6844_(EquipmentSlot.HEAD).m_204117_(OTags.Items.PROTECTIVE_HELMET));
        LeadProtections.register(entity -> {
            for (ItemStack slot : entity.m_6168_()) {
                if (slot.m_204117_(OTags.Items.PROTECTIVE_ARMOR_PART)) continue;
                return false;
            }
            return true;
        });
    }

    private void injectVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35595_) {
            ((List)event.getTrades().get(5)).add(new BasicItemListing(14, new ItemStack((ItemLike)OBlocks.GARGOYLE.get()), 5, 30, 0.05f));
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)OFluids.MOLTEN_LEAD_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, pos, relativePos, fluidState) -> level.m_6425_(relativePos).m_205070_(FluidTags.f_13131_) && fluidState.m_76170_(), fluidState -> ((MeltableBlock)OBlocks.LEAD_BLOCK.get()).m_49966_()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)OFluids.MOLTEN_LEAD_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, blockPos, relativePos, fluidState) -> level.m_6425_(relativePos).m_205070_(FluidTags.f_13132_) && fluidState.m_76170_(), (level, pos, relativePos, fluidState) -> {
            LeadOreBlock.spawnCloud(level, pos, 2.0f);
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            level.m_46796_(1501, pos, 0);
        }));
        event.enqueueWork(() -> {
            Map EMPTY = CauldronInteraction.f_175606_;
            Map WATER = CauldronInteraction.f_175607_;
            Map LAVA = CauldronInteraction.f_175608_;
            Map POWDER_SNOW = CauldronInteraction.f_175609_;
            Map<Item, CauldronInteraction> LEAD = MoltenLeadCauldronBlock.INTERACTION_MAP;
            EMPTY.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            WATER.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            LAVA.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            POWDER_SNOW.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            LEAD.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            if (((Boolean)OreganizedConfig.COMMON.cauldronLeadMelting.get()).booleanValue()) {
                EMPTY.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
                WATER.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
                LAVA.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
                POWDER_SNOW.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).m_5456_(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
            }
            LEAD.put(Items.f_41852_, MoltenLeadCauldronBlock.EMPTY_LEAD_BLOCK);
            LEAD.put(Items.f_42446_, MoltenLeadCauldronBlock.EMPTY_MOLTEN_LEAD);
            CauldronInteraction.m_175647_(MoltenLeadCauldronBlock.INTERACTION_MAP);
            PotionBrewing.m_43513_((Potion)Potions.f_43599_, (Item)((Item)OItems.LEAD_INGOT.get()), (Potion)((Potion)OPotions.STUNNING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)OPotions.STUNNING.get()), (Item)Items.f_42451_, (Potion)((Potion)OPotions.LONG_STUNNING.get()));
            FireBlock fire = (FireBlock)Blocks.f_50083_;
            fire.m_53444_((Block)OBlocks.SHRAPNEL_BOMB.get(), 15, 100);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)OItems.LEAD_BOLT.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position pos, ItemStack stack) {
                    LeadBoltEntity entity = new LeadBoltEntity((EntityType<? extends LeadBoltEntity>)((EntityType)OEntityTypes.LEAD_BOLT.get()), level, pos);
                    entity.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                    return entity;
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)OItems.MOLTEN_LEAD_BUCKET.get()), (DispenseItemBehavior)new FishBucketDispenseItemBehavior());
            Stream.of("lead_bolt_crates1", "lead_bolt_crates2").forEach(name -> DataUtil.addToJigsawPattern((ResourceLocation)new ResourceLocation("pillager_outpost/features"), $ -> (StructurePoolElement)StructurePoolElement.m_210507_((String)("oreganized:pillager_outpost/" + name)).apply(StructureTemplatePool.Projection.RIGID), (int)1));
        });
        ImmutableBiMap.Builder waxedBlocks = new ImmutableBiMap.Builder();
        waxedBlocks.put((Object)((Block)OBlocks.WAXED_SPOTTED_GLANCE.get()), (Object)((Block)OBlocks.SPOTTED_GLANCE.get()));
        OBlocks.WAXED_CONCRETE_POWDER.forEach((color, waxed) -> {
            Block unwaxed = ColorCompat.getColoredBlock("concrete_powder", color);
            waxedBlocks.put((Object)((Block)waxed.get()), (Object)unwaxed);
        });
        OBlocks.WAXED_BLOCKS = waxedBlocks.build();
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        OLang lang = new OLang(output);
        generator.addProvider(client, (DataProvider)new OBlockStates(output, helper));
        generator.addProvider(client, (DataProvider)new OItemModels(output, helper));
        generator.addProvider(client, (DataProvider)lang);
        generator.addProvider(client, (DataProvider)new OSoundDefinitions(output, helper));
        generator.addProvider(client, (DataProvider)new OSpriteSourceProvider(output, helper));
        generator.addProvider(server, (DataProvider)new ORecipes(output));
        generator.addProvider(server, (DataProvider)new OLootTables(output));
        OBlockTags blockTags = new OBlockTags(output, lookup, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new OItemTags(output, lookup, blockTags.m_274426_(), helper));
        generator.addProvider(server, (DataProvider)new OEntityTags(output, lookup, helper));
        generator.addProvider(server, (DataProvider)new OAdvancements(output, lookup, helper, lang));
        generator.addProvider(server, (DataProvider)new OFluidTags(output, lookup, helper));
        ORegistries datapackProvider = new ORegistries(output, lookup);
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(server, (DataProvider)datapackProvider);
        generator.addProvider(server, (DataProvider)new OBiomeTags(output, lookupProvider, helper));
        generator.addProvider(server, (DataProvider)new ODamageTags(output, lookupProvider, helper));
        generator.addProvider(server, (DataProvider)new OPaintingVariantTags(output, lookupProvider, helper));
        generator.addProvider(server, (DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)"Oreganized resources"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES))));
    }
}

