/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.entity;

import galena.oreganized.content.block.GargoyleBlock;
import galena.oreganized.index.OBlockEntities;
import galena.oreganized.index.OCriteriaTriggers;
import galena.oreganized.index.OParticleTypes;
import galena.oreganized.index.OSoundEvents;
import galena.oreganized.index.OTags;
import galena.oreganized.network.OreganizedNetwork;
import galena.oreganized.network.packet.GargoyleParticlePacket;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class GargoyleBlockEntity
extends BlockEntity {
    private static final int COOLDOWN = 600;
    public static final String GROWL_COOLDOWN_TAG = "oreganized:gargoyle_use_cooldown";
    private int outputSignal = 0;
    private int updateCooldown = 0;
    private int growlCooldown = 0;
    private ParticleOptions drippingFluid;
    private final Direction fluidOffset;

    public GargoyleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)OBlockEntities.GARGOYLE.get(), pos, state);
        GargoyleBlock.AttachmentType attachment = (GargoyleBlock.AttachmentType)((Object)state.m_61143_(GargoyleBlock.ATTACHMENT));
        Direction facing = (Direction)state.m_61143_((Property)GargoyleBlock.f_54117_);
        this.fluidOffset = attachment == GargoyleBlock.AttachmentType.FLOOR ? Direction.DOWN : facing;
    }

    private static Collection<Mob> getTargets(Level level, BlockPos pos) {
        AABB box = new AABB(pos).m_82400_(10.0);
        return level.m_6443_(Mob.class, box, it -> it.m_6336_() == MobType.f_21641_);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GargoyleBlockEntity be) {
        --be.growlCooldown;
        if (be.updateCooldown % 2 == 0 && be.drippingFluid != null) {
            GargoyleBlock.dripParticles(state, level, pos, level.f_46441_, be.drippingFluid);
        }
        if (--be.updateCooldown > 0) {
            return;
        }
        be.updateDripParticles(level, pos, state);
        Collection<Mob> targets = GargoyleBlockEntity.getTargets(level, pos);
        Vec3 vec = Vec3.m_82512_((Vec3i)pos);
        double closestDistance = targets.stream().mapToDouble(it -> it.m_20238_(vec)).map(Math::sqrt).map(Math::floor).sorted().findFirst().orElse(100.0);
        int newOutputSignal = Math.max(14 - (int)closestDistance, 0);
        if (newOutputSignal != be.outputSignal) {
            be.outputSignal = newOutputSignal;
            level.m_46717_(pos, be.m_58900_().m_60734_());
        }
        be.updateCooldown = 10;
    }

    private void updateDripParticles(Level level, BlockPos pos, BlockState state) {
        for (int i = 1; i <= 2; ++i) {
            BlockPos targetPos = pos.m_5484_(this.fluidOffset, i);
            BlockState targetState = level.m_8055_(targetPos);
            FluidState fluid = targetState.m_60819_();
            if (!fluid.m_76178_()) {
                this.drippingFluid = fluid.m_76189_();
                if (fluid.m_192917_((Fluid)Fluids.f_76193_)) {
                    level.m_45976_(ServerPlayer.class, new AABB(pos).m_82377_(10.0, 5.0, 10.0)).forEach(player -> OCriteriaTriggers.SEE_GARGOYLE_GARGLE.trigger((ServerPlayer)player));
                }
                return;
            }
            if (!targetState.m_60796_((BlockGetter)level, pos) || !targetState.m_60783_((BlockGetter)level, pos, Direction.UP) || !targetState.m_60783_((BlockGetter)level, pos, Direction.DOWN)) break;
        }
        this.drippingFluid = level.m_46758_(pos.m_7494_()) ? ParticleTypes.f_175824_ : null;
    }

    public int getAnalogOutputSignal() {
        return this.outputSignal;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("cooldown", this.growlCooldown);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("cooldown")) {
            this.growlCooldown = tag.m_128451_("cooldown");
        }
    }

    public InteractionResult interact(Level level, BlockPos pos, @Nullable Player player, ItemStack stack, boolean simulate) {
        if (this.growlCooldown > 0) {
            return InteractionResult.PASS;
        }
        if (player != null && player.getPersistentData().m_128451_(GROWL_COOLDOWN_TAG) > 0) {
            return InteractionResult.PASS;
        }
        if (!stack.m_204117_(OTags.Items.GARGOYLE_SNACK)) {
            return InteractionResult.PASS;
        }
        if (player == null || !player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        if (simulate) {
            return InteractionResult.SUCCESS;
        }
        GargoyleBlockEntity.getTargets(level, pos).forEach(mob -> this.scare((Entity)mob, pos));
        level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (SoundEvent)OSoundEvents.GARGOYLE_GROWL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.growlCooldown = 600;
        if (player != null && !player.m_150110_().f_35937_) {
            player.getPersistentData().m_128405_(GROWL_COOLDOWN_TAG, 600);
        }
        if (!level.f_46443_) {
            OreganizedNetwork.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new GargoyleParticlePacket(pos));
        }
        return InteractionResult.SUCCESS;
    }

    private void scare(Entity mob, BlockPos pos) {
        Vec3 offset = mob.m_20182_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (offset.m_82553_() < 4.0) {
            Vec3 motion = offset.m_82542_(0.4, 0.2, 0.4);
            mob.m_5997_(motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
        mob.getPersistentData().m_128365_("ScaredByGargoyle", (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    public void spawnParticles() {
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)GargoyleBlock.f_54117_);
        GargoyleBlock.AttachmentType attachment = (GargoyleBlock.AttachmentType)((Object)state.m_61143_(GargoyleBlock.ATTACHMENT));
        ParticleUtils.m_216313_((Level)this.f_58857_, (BlockPos)pos, (ParticleOptions)((ParticleOptions)OParticleTypes.VENGEANCE.get()), (IntProvider)UniformInt.m_146622_((int)0, (int)2));
        if (attachment == GargoyleBlock.AttachmentType.WALL) {
            ParticleUtils.m_216313_((Level)this.f_58857_, (BlockPos)pos.m_121945_(facing.m_122424_()), (ParticleOptions)((ParticleOptions)OParticleTypes.VENGEANCE.get()), (IntProvider)UniformInt.m_146622_((int)0, (int)1));
        }
    }
}

