/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.world.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import galena.oreganized.index.ORecipeTypes;
import galena.oreganized.world.recipe.BlockPredicateNetworking;
import galena.oreganized.world.recipe.BlockRecipeInput;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record ScribeRecipe(ResourceLocation id, BlockPredicate from, Block to, boolean dropResources) implements Recipe<BlockRecipeInput>
{
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean matches(BlockRecipeInput input, Level level) {
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return this.from.m_17914_(serverLevel, input.block().m_61176_()) && !input.block().m_61168_().m_60713_(this.to);
    }

    public ItemStack assemble(BlockRecipeInput input, RegistryAccess provider) {
        return this.m_8043_(provider);
    }

    public boolean m_8004_(int height, int width) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess provider) {
        return this.to.m_5456_().m_7968_();
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ORecipeTypes.SCRIBE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ORecipeTypes.SCRIBE_RECIPE.get();
    }

    public record Finished(ResourceLocation id, ScribeRecipe recipe) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            ((Serializer)ORecipeTypes.SCRIBE_SERIALIZER.get()).toJson(this.id(), this.recipe, json);
        }

        public ResourceLocation m_6445_() {
            return this.id();
        }

        public RecipeSerializer<?> m_6637_() {
            return this.recipe.m_7707_();
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }

    public static class Builder
    implements RecipeBuilder {
        private BlockPredicate.Builder from;
        private Block to;
        private boolean dropResources = false;
        private Set<ICondition> conditions = new HashSet<ICondition>();

        public Builder unlockedBy(String key, CriterionTriggerInstance criterion) {
            return this;
        }

        public Builder group(@Nullable String group) {
            return this;
        }

        public Item m_142372_() {
            return this.to.m_5456_();
        }

        public ScribeRecipe build(ResourceLocation id) {
            Objects.requireNonNull(this.from);
            Objects.requireNonNull(this.to);
            return new ScribeRecipe(id, this.from.m_17931_(), this.to, this.dropResources);
        }

        public Builder result(Block block) {
            this.to = block;
            return this;
        }

        public Builder from(BlockPredicate.Builder predicate) {
            this.from = predicate;
            return this;
        }

        public Builder from(Block block) {
            return this.from(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{block}));
        }

        public Builder from(TagKey<Block> tag) {
            return this.from(BlockPredicate.Builder.m_17924_().m_204027_(tag));
        }

        public Builder when(String ... modIds) {
            return this.when((ICondition[])Arrays.stream(modIds).map(ModLoadedCondition::new).toArray(ICondition[]::new));
        }

        public Builder when(ICondition ... conditions) {
            this.conditions.addAll(Arrays.asList(conditions));
            return this;
        }

        public Builder dropResources(boolean value) {
            this.dropResources = value;
            return this;
        }

        public Builder dropResources() {
            return this.dropResources(true);
        }

        public void m_126140_(Consumer<FinishedRecipe> output, ResourceLocation id) {
            output.accept(new Finished(id.m_246208_("scribe/"), this.build(id)));
        }
    }

    public static class Serializer
    implements RecipeSerializer<ScribeRecipe> {
        public ScribeRecipe fromJson(ResourceLocation id, JsonObject json) {
            return new ScribeRecipe(id, BlockPredicate.m_17917_((JsonElement)json.get("from")), (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"to"))), GsonHelper.m_13855_((JsonObject)json, (String)"drop_resources", (boolean)false));
        }

        @Nullable
        public ScribeRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            return new ScribeRecipe(id, BlockPredicateNetworking.decode(buffer), (Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS), buffer.readBoolean());
        }

        public void toNetwork(FriendlyByteBuf buffer, ScribeRecipe recipe) {
            BlockPredicateNetworking.encode(buffer, recipe.from());
            buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (Object)recipe.to());
            buffer.writeBoolean(recipe.dropResources());
        }

        public void toJson(ResourceLocation id, ScribeRecipe recipe, JsonObject json) {
            json.addProperty("id", id.toString());
            json.add("from", recipe.from().m_17913_());
            json.addProperty("to", ForgeRegistries.BLOCKS.getKey((Object)recipe.to()).toString());
            if (recipe.dropResources()) {
                json.addProperty("drop_resources", Boolean.valueOf(true));
            }
        }
    }
}

