/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized;

import com.mojang.serialization.MapCodec;
import com.teamabnormals.blueprint.common.dispenser.FishBucketDispenseItemBehavior;
import com.teamabnormals.blueprint.core.util.DataUtil;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import galena.oreganized.OreganizedConfig;
import galena.oreganized.api.LeadProtections;
import galena.oreganized.compat.create.CreateCompat;
import galena.oreganized.content.block.LeadOreBlock;
import galena.oreganized.content.block.MeltableBlock;
import galena.oreganized.content.block.MoltenLeadCauldronBlock;
import galena.oreganized.data.OAdvancements;
import galena.oreganized.data.OBiomeTags;
import galena.oreganized.data.OBlockStates;
import galena.oreganized.data.OBlockTags;
import galena.oreganized.data.ODamageTags;
import galena.oreganized.data.ODataMaps;
import galena.oreganized.data.OEnchantmentTags;
import galena.oreganized.data.OEntityTags;
import galena.oreganized.data.OFluidTags;
import galena.oreganized.data.OItemModels;
import galena.oreganized.data.OItemTags;
import galena.oreganized.data.OLang;
import galena.oreganized.data.OLootTables;
import galena.oreganized.data.OPaintingVariantTags;
import galena.oreganized.data.ORecipes;
import galena.oreganized.data.ORegistries;
import galena.oreganized.data.OSoundDefinitions;
import galena.oreganized.data.OSpriteSourceProvider;
import galena.oreganized.index.OArmorMaterials;
import galena.oreganized.index.OAttributes;
import galena.oreganized.index.OBlockEntities;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OCriteriaTriggers;
import galena.oreganized.index.ODataComponents;
import galena.oreganized.index.OEffects;
import galena.oreganized.index.OEntityTypes;
import galena.oreganized.index.OFluids;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OParticleTypes;
import galena.oreganized.index.OPotions;
import galena.oreganized.index.ORecipeTypes;
import galena.oreganized.index.OSoundEvents;
import galena.oreganized.index.OStructures;
import galena.oreganized.index.OTags;
import galena.oreganized.network.OreganizedNetwork;
import galena.oreganized.world.AddItemLootModifier;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.DetectedVersion;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.BasicItemListing;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="oreganized")
public class Oreganized {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "oreganized";
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("oreganized");
    private static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"oreganized");

    public static ResourceLocation modLoc(String location) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)location);
    }

    public Oreganized(IEventBus modBus, ModContainer container) {
        IEventBus forgeBus = NeoForge.EVENT_BUS;
        OreganizedConfig.register(container);
        modBus.addListener(this::setup);
        modBus.addListener(this::clientSetup);
        modBus.addListener(this::gatherData);
        forgeBus.addListener(this::injectVillagerTrades);
        forgeBus.addListener(this::registerPotionMixes);
        LOOT_MODIFIERS.register("add_item", () -> AddItemLootModifier.CODEC);
        OEffects.register(modBus);
        OEntityTypes.register(modBus);
        OFluids.register(modBus);
        OParticleTypes.register(modBus);
        OPotions.register(modBus);
        OStructures.register(modBus);
        OAttributes.register(modBus);
        OArmorMaterials.register(modBus);
        ODataComponents.register(modBus);
        LOOT_MODIFIERS.register(modBus);
        OBlockEntities.register();
        OBlocks.register();
        OItems.register();
        OCriteriaTriggers.register(modBus);
        OSoundEvents.register();
        ORecipeTypes.register(modBus);
        REGISTRY_HELPER.register(modBus);
        modBus.addListener(OreganizedNetwork::register);
        boolean createLoaded = ModList.get().getModContainerById("create").filter(it -> it.getModInfo().getVersion().getMajorVersion() >= 6).isPresent();
        if (createLoaded) {
            CreateCompat.register(modBus);
        }
        LeadProtections.register(entity -> entity.getItemBySlot(EquipmentSlot.HEAD).is(OTags.Items.PROTECTIVE_HELMET));
        LeadProtections.register(entity -> {
            for (ItemStack slot : entity.getArmorSlots()) {
                if (slot.is(OTags.Items.PROTECTIVE_ARMOR_PART)) continue;
                return false;
            }
            return true;
        });
    }

    private void injectVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.MASON) {
            ((List)event.getTrades().get(5)).add(new BasicItemListing(14, new ItemStack((ItemLike)OBlocks.GARGOYLE.get()), 5, 30, 0.05f));
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)OFluids.MOLTEN_LEAD_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, pos, relativePos, fluidState) -> level.getFluidState(relativePos).is(FluidTags.WATER) && fluidState.isSource(), fluidState -> ((MeltableBlock)OBlocks.LEAD_BLOCK.get()).defaultBlockState()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)OFluids.MOLTEN_LEAD_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, blockPos, relativePos, fluidState) -> level.getFluidState(relativePos).is(FluidTags.LAVA) && fluidState.isSource(), (level, pos, relativePos, fluidState) -> {
            LeadOreBlock.spawnCloud(level, pos, 2.0f);
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            level.levelEvent(1501, pos, 0);
        }));
        event.enqueueWork(() -> {
            Map EMPTY = CauldronInteraction.EMPTY.map();
            Map WATER = CauldronInteraction.WATER.map();
            Map LAVA = CauldronInteraction.LAVA.map();
            Map POWDER_SNOW = CauldronInteraction.POWDER_SNOW.map();
            Map LEAD = MoltenLeadCauldronBlock.INTERACTION_MAP.map();
            EMPTY.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            WATER.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            LAVA.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            POWDER_SNOW.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            LEAD.put((Item)OItems.MOLTEN_LEAD_BUCKET.get(), MoltenLeadCauldronBlock.FILL_MOLTEN_LEAD);
            if (((Boolean)OreganizedConfig.COMMON.cauldronLeadMelting.get()).booleanValue()) {
                EMPTY.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).asItem(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
                WATER.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).asItem(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
                LAVA.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).asItem(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
                POWDER_SNOW.put(((MeltableBlock)OBlocks.LEAD_BLOCK.get()).asItem(), MoltenLeadCauldronBlock.FILL_LEAD_BLOCK);
            }
            LEAD.put(Items.AIR, MoltenLeadCauldronBlock.EMPTY_LEAD_BLOCK);
            LEAD.put(Items.BUCKET, MoltenLeadCauldronBlock.EMPTY_MOLTEN_LEAD);
            CauldronInteraction.addDefaultInteractions((Map)MoltenLeadCauldronBlock.INTERACTION_MAP.map());
            FireBlock fire = (FireBlock)Blocks.FIRE;
            fire.setFlammable((Block)OBlocks.SHRAPNEL_BOMB.get(), 15, 100);
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)OItems.LEAD_BOLT.get()), (DispenseItemBehavior)new ProjectileDispenseBehavior((Item)OItems.LEAD_BOLT.get()));
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)OItems.MOLTEN_LEAD_BUCKET.get()), (DispenseItemBehavior)new FishBucketDispenseItemBehavior());
            Stream.of("lead_bolt_crates1", "lead_bolt_crates2").forEach(name -> DataUtil.addToJigsawPattern((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"pillager_outpost/features"), $ -> (StructurePoolElement)StructurePoolElement.legacy((String)("oreganized:pillager_outpost/" + name)).apply(StructureTemplatePool.Projection.RIGID), (int)1));
        });
    }

    private void clientSetup(FMLClientSetupEvent event) {
    }

    private void registerPotionMixes(RegisterBrewingRecipesEvent event) {
        event.getBuilder().addMix(Potions.WATER, (Item)OItems.LEAD_INGOT.get(), OPotions.STUNNING);
        event.getBuilder().addMix(OPotions.STUNNING, Items.REDSTONE, OPotions.LONG_STUNNING);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookup = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean client = event.includeClient();
        boolean server = event.includeServer();
        OLang lang = new OLang(output);
        generator.addProvider(client, (DataProvider)new OBlockStates(output, helper));
        generator.addProvider(client, (DataProvider)new OItemModels(output, helper));
        generator.addProvider(client, (DataProvider)lang);
        generator.addProvider(client, (DataProvider)new OSoundDefinitions(output, helper));
        generator.addProvider(client, (DataProvider)new OSpriteSourceProvider(output, lookup, helper));
        generator.addProvider(server, (DataProvider)new ORecipes(output, lookup));
        generator.addProvider(server, (DataProvider)new OLootTables(output, lookup));
        OBlockTags blockTags = new OBlockTags(output, lookup, helper);
        generator.addProvider(server, (DataProvider)blockTags);
        generator.addProvider(server, (DataProvider)new OItemTags(output, lookup, blockTags.contentsGetter(), helper));
        generator.addProvider(server, (DataProvider)new OEntityTags(output, lookup, helper));
        generator.addProvider(server, (DataProvider)new OAdvancements(output, lookup, helper, lang));
        generator.addProvider(server, (DataProvider)new OFluidTags(output, lookup, helper));
        generator.addProvider(server, (DataProvider)new OEnchantmentTags(output, lookup, helper));
        ORegistries datapackProvider = new ORegistries(output, lookup);
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(server, (DataProvider)datapackProvider);
        generator.addProvider(server, (DataProvider)new OBiomeTags(output, lookupProvider, helper));
        generator.addProvider(server, (DataProvider)new ODamageTags(output, lookupProvider, helper));
        generator.addProvider(server, (DataProvider)new OPaintingVariantTags(output, lookupProvider, helper));
        generator.addProvider(server, (DataProvider)new ODataMaps(output, lookupProvider));
        generator.addProvider(server, (DataProvider)new PackMetadataGenerator(output).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)"Oreganized resources"), DetectedVersion.BUILT_IN.getPackVersion(PackType.CLIENT_RESOURCES), Optional.empty())));
    }
}

