/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized;

import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class OreganizedConfig {
    public static final Common COMMON;
    public static final Client CLIENT;
    private static final ModConfigSpec COMMON_SPEC;
    private static final ModConfigSpec CLIENT_SPEC;

    public static void register(ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_SPEC);
    }

    static {
        Pair commonSpecPair = new ModConfigSpec.Builder().configure(Common::new);
        Pair clientSpecPair = new ModConfigSpec.Builder().configure(Client::new);
        COMMON = (Common)commonSpecPair.getLeft();
        CLIENT = (Client)clientSpecPair.getLeft();
        COMMON_SPEC = (ModConfigSpec)commonSpecPair.getRight();
        CLIENT_SPEC = (ModConfigSpec)clientSpecPair.getRight();
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<Boolean> poisonInsteadOfStunning;
        public final ModConfigSpec.ConfigValue<Boolean> leadDustCloud;
        public final ModConfigSpec.ConfigValue<Boolean> pillagerSpawnWithBolts;
        public final ModConfigSpec.ConfigValue<Boolean> scribeSilkTouchStone;
        public final ModConfigSpec.ConfigValue<Integer> moltenLeadDelay;
        public final ModConfigSpec.ConfigValue<Boolean> cauldronLeadMelting;

        private Common(ModConfigSpec.Builder builder) {
            builder.comment("Common");
            builder.push("common");
            this.poisonInsteadOfStunning = builder.comment("Should lead poisoning events give just Poison instead of Brain Damage?").define("poisonInsteadOfBrainDamage", false);
            this.leadDustCloud = builder.comment("Should lead ore spawn dust clouds when broken without adjacent water?").define("leadDustCloud", true);
            this.pillagerSpawnWithBolts = builder.comment("Pillagers have a chance to spawn with a lead bolt in their offhand").define("pillagerSpawnWithBolts", true);
            this.scribeSilkTouchStone = builder.comment("The scribe is able to silk-touch pickaxe-related blocks").define("scribeSilkTouchStone", true);
            this.moltenLeadDelay = builder.comment("Time in ticks molten lead waits until flowing downwards").defineInRange("moltenLeadDelay", 200, 0, 2000);
            this.cauldronLeadMelting = builder.comment("Can lead blocks be placed into a cauldron to melt?").define("cauldronLeadMelting", true);
            builder.pop();
        }
    }

    public static class Client {
        public final ModConfigSpec.ConfigValue<Boolean> renderStunningOverlay;

        public Client(ModConfigSpec.Builder builder) {
            builder.comment("Client");
            builder.push("client");
            this.renderStunningOverlay = builder.comment("Should the custom overlay for the brain damage effect be rendered?").define("renderBrainDamageOverlay", true);
            builder.pop();
        }
    }
}

