/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import galena.oreganized.Oreganized;
import galena.oreganized.client.DevicePropertyFunction;
import galena.oreganized.client.extensions.ElectrumArmorClientExtensions;
import galena.oreganized.client.extensions.MoltenLeadClientExtensions;
import galena.oreganized.client.render.entity.LeadBoltRender;
import galena.oreganized.client.render.entity.ShrapnelBombMinecartRender;
import galena.oreganized.client.render.entity.ShrapnelBombRender;
import galena.oreganized.client.render.gui.StunningOverlay;
import galena.oreganized.client.tooltips.ClientDeviceTooltip;
import galena.oreganized.client.tooltips.ClientThermometerTooltip;
import galena.oreganized.client.tooltips.DeviceTooltip;
import galena.oreganized.client.tooltips.ThermometerTooltip;
import galena.oreganized.content.item.SpeedometerItem;
import galena.oreganized.content.item.ThermometerItem;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.ODataComponents;
import galena.oreganized.index.OEntityTypes;
import galena.oreganized.index.OFluids;
import galena.oreganized.index.OItems;
import galena.oreganized.world.IDoorProgressHolder;
import galena.oreganized.world.IMotionHolder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="oreganized", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class OreganizedClient {
    private static void render(Supplier<? extends Block> block, RenderType render) {
        ItemBlockRenderTypes.setRenderLayer((Block)block.get(), (RenderType)render);
    }

    @SubscribeEvent
    public static void setup(FMLClientSetupEvent event) {
        OreganizedClient.registerBlockRenderers();
        OreganizedClient.registerItemProperties();
    }

    private static void registerItemProperties() {
        ItemProperties.register((Item)((Item)OItems.SILVER_MIRROR.get()), (ResourceLocation)ODataComponents.MIRROR_LEVEL.getId(), (stack, world, entity, seed) -> ((Integer)stack.getOrDefault((DataComponentType)ODataComponents.MIRROR_LEVEL.get(), (Object)8)).intValue());
        ItemProperties.register((Item)((Item)OItems.SPEEDOMETER.get()), (ResourceLocation)SpeedometerItem.PROPERTY_KEY, (stack, world, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            Entity vehicle = entity.getRootVehicle();
            if (!(vehicle instanceof IMotionHolder)) {
                return 0.0f;
            }
            IMotionHolder motionHolder = (IMotionHolder)vehicle;
            return Mth.clamp((long)Math.round(motionHolder.oreganised$getMotion() * 100.0), (long)0L, (long)16L);
        });
        ItemProperties.register((Item)((Item)OItems.THERMOMETER.get()), (ResourceLocation)ODataComponents.HEAT_LEVEL.getId(), (stack, world, entity, seed) -> ThermometerItem.getHeatLevel(stack));
        ItemProperties.register((Item)Items.CROSSBOW, (ResourceLocation)Oreganized.modLoc("lead_bolt"), (stack, level, user, i) -> ((ChargedProjectiles)stack.getOrDefault(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.EMPTY)).contains((Item)OItems.LEAD_BOLT.get()) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)OItems.ELECTRUM_SHIELD.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"blocking"), (stack, level, user, i) -> user != null && user.isUsingItem() && user.getUseItem() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)OItems.UNKNOWN_DEVICE.get()), (ResourceLocation)ODataComponents.DEVICE_VALUE.getId(), (ItemPropertyFunction)new DevicePropertyFunction());
    }

    private static void registerBlockRenderers() {
        RenderType cutout = RenderType.cutout();
        RenderType translucent = RenderType.translucent();
        OreganizedClient.render(OBlocks.LEAD_DOOR, cutout);
        OreganizedClient.render(OBlocks.LEAD_TRAPDOOR, cutout);
        OreganizedClient.render(OBlocks.LEAD_BARS, cutout);
        OreganizedClient.render(OBlocks.GARGOYLE, cutout);
        OreganizedClient.render(OBlocks.WHITE_DATURA, cutout);
        OreganizedClient.render(OBlocks.PURPLE_DATURA, cutout);
        OreganizedClient.render(OBlocks.POTTED_WHITE_DATURA, cutout);
        OreganizedClient.render(OBlocks.POTTED_PURPLE_DATURA, cutout);
        OBlocks.CRYSTAL_GLASS.forEach((c, b) -> OreganizedClient.render((Supplier<? extends Block>)b, translucent));
        OBlocks.CRYSTAL_GLASS_PANES.forEach((c, b) -> OreganizedClient.render((Supplier<? extends Block>)b, translucent));
        OreganizedClient.render(OBlocks.GROOVED_ICE, translucent);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)OEntityTypes.SHRAPNEL_BOMB.value(), ShrapnelBombRender::new);
        event.registerEntityRenderer((EntityType)OEntityTypes.SHRAPNEL_BOMB_MINECART.get(), ShrapnelBombMinecartRender::new);
        event.registerEntityRenderer((EntityType)OEntityTypes.LEAD_BOLT.get(), LeadBoltRender::new);
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.EFFECTS, Oreganized.modLoc("stunning"), (LayeredDraw.Layer)new StunningOverlay());
    }

    public static void renderThirdPersonArm(ModelPart arm, boolean rightArm) {
        arm.xRot = -1.7f;
        arm.yRot = rightArm ? -0.1f : 0.2f;
    }

    @SubscribeEvent
    public static void registerClientTooltips(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ThermometerTooltip.class, ClientThermometerTooltip::new);
        event.register(DeviceTooltip.class, ClientDeviceTooltip::new);
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType((IClientFluidTypeExtensions)new MoltenLeadClientExtensions(), new Holder[]{OFluids.MOLTEN_LEAD_TYPE});
        event.registerItem((IClientItemExtensions)new ElectrumArmorClientExtensions(), new Holder[]{OItems.ELECTRUM_HELMET, OItems.ELECTRUM_CHESTPLATE, OItems.ELECTRUM_LEGGINGS, OItems.ELECTRUM_BOOTS});
    }

    @EventBusSubscriber(modid="oreganized", value={Dist.CLIENT})
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void addTooltips(ItemTooltipEvent event) {
            if (event.getItemStack().is((Item)OItems.BUSH_HAMMER.get())) {
                List tooltip = event.getToolTip();
                MutableComponent wipTitle = Component.translatable((String)"tooltip.oreganized.wip.title");
                MutableComponent wipDesc = Component.translatable((String)"tooltip.oreganized.wip.description");
                tooltip.add(wipTitle.withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.BOLD));
                tooltip.add(wipDesc.withStyle(ChatFormatting.DARK_PURPLE).withStyle(ChatFormatting.ITALIC));
            }
        }

        @SubscribeEvent
        public static void renderHand(RenderHandEvent event) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (!(player instanceof IDoorProgressHolder)) {
                return;
            }
            IDoorProgressHolder progressHolder = (IDoorProgressHolder)player;
            int progress = progressHolder.oreganised$getOpeningProgress();
            if (progress == 0) {
                return;
            }
            if (event.getHand() == InteractionHand.OFF_HAND) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            boolean rightArm = player.getMainArm() == HumanoidArm.RIGHT;
            float factor = rightArm ? 1.0f : -1.0f;
            poseStack.translate(factor * 0.84000003f, -0.4f, -0.4f);
            poseStack.mulPose(Axis.YP.rotationDegrees(factor * -20.0f - event.getSwingProgress()));
            poseStack.mulPose(Axis.ZP.rotationDegrees(factor * 45.0f));
            poseStack.mulPose(Axis.XP.rotationDegrees(-45.0f));
            PlayerRenderer renderer = (PlayerRenderer)Minecraft.getInstance().getEntityRenderDispatcher().getRenderer((Entity)player);
            if (rightArm) {
                renderer.renderRightHand(poseStack, event.getMultiBufferSource(), event.getPackedLight(), (AbstractClientPlayer)player);
            } else {
                renderer.renderLeftHand(poseStack, event.getMultiBufferSource(), event.getPackedLight(), (AbstractClientPlayer)player);
            }
            poseStack.popPose();
            event.setCanceled(true);
        }
    }
}

