/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import galena.oreganized.Oreganized;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;

public class ElectrumArmorModel<T extends LivingEntity>
extends HumanoidArmorModel<T> {
    public static final ModelLayerLocation ELECTRUM_ARMOR = new ModelLayerLocation(Oreganized.modLoc("electrum_armor"), "main");
    private final EquipmentSlot slot;
    private final ModelPart Head;
    private final ModelPart Body;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;
    private final ModelPart RightBoot;
    private final ModelPart LeftBoot;

    public ElectrumArmorModel(ModelPart root, EquipmentSlot slot) {
        super(root);
        this.slot = slot;
        this.Head = root.getChild("Head");
        this.Body = root.getChild("Body");
        this.RightArm = root.getChild("RightArm");
        this.LeftArm = root.getChild("LeftArm");
        this.RightLeg = root.getChild("RightLeg");
        this.LeftLeg = root.getChild("LeftLeg");
        this.RightBoot = root.getChild("RightBoot");
        this.LeftBoot = root.getChild("LeftBoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidArmorModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Head = partdefinition.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.75f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition LeftWing_r1 = Head.addOrReplaceChild("LeftWing_r1", CubeListBuilder.create().texOffs(32, 41).addBox(6.0f, -11.0f, -6.0f, 0.0f, 11.0f, 12.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f, (float)0.0f));
        PartDefinition RightWing_r1 = Head.addOrReplaceChild("RightWing_r1", CubeListBuilder.create().texOffs(32, 41).addBox(-6.0f, -11.0f, -6.0f, 0.0f, 11.0f, 12.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(40, 21).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.51f)).texOffs(40, 14).addBox(-4.0f, 9.0f, -2.0f, 8.0f, 3.0f, 4.0f, new CubeDeformation(0.4f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightArm = partdefinition.addOrReplaceChild("RightArm", CubeListBuilder.create().texOffs(48, 37).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.addOrReplaceChild("LeftArm", CubeListBuilder.create().texOffs(32, 37).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.6f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.addOrReplaceChild("RightLeg", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.31f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.addOrReplaceChild("LeftLeg", CubeListBuilder.create().texOffs(16, 0).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.3f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition RightBoot = partdefinition.addOrReplaceChild("RightBoot", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 8.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.51f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition RightFootWing_r1 = RightBoot.addOrReplaceChild("RightFootWing_r1", CubeListBuilder.create().texOffs(16, 12).addBox(-2.8f, 5.0f, -1.0f, 0.0f, 6.0f, 8.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)0.0f));
        PartDefinition LeftBoot = partdefinition.addOrReplaceChild("LeftBoot", CubeListBuilder.create().texOffs(0, 24).addBox(-2.0f, 8.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        PartDefinition LeftFootWing_r1 = LeftBoot.addOrReplaceChild("LeftFootWing_r1", CubeListBuilder.create().texOffs(16, 18).addBox(2.8f, 5.0f, -1.0f, 0.0f, 6.0f, 8.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        if (this.slot == EquipmentSlot.HEAD) {
            poseStack.pushPose();
            this.Head.copyFrom(this.head);
            if (this.young) {
                poseStack.scale(0.75f, 0.75f, 0.75f);
                this.Head.setPos(0.0f, 15.0f, 0.0f);
            }
            this.Head.render(poseStack, buffer, packedLight, packedOverlay);
            poseStack.popPose();
        }
        if (this.slot == EquipmentSlot.CHEST) {
            poseStack.pushPose();
            this.Body.copyFrom(this.body);
            this.RightArm.copyFrom(this.rightArm);
            this.LeftArm.copyFrom(this.leftArm);
            if (this.young) {
                poseStack.scale(0.5f, 0.5f, 0.5f);
                this.Body.setPos(0.0f, 24.0f, 0.0f);
                this.RightArm.setPos(-5.0f, 24.0f, 0.0f);
                this.LeftArm.setPos(5.0f, 24.0f, 0.0f);
            }
            this.RightArm.render(poseStack, buffer, packedLight, packedOverlay);
            this.LeftArm.render(poseStack, buffer, packedLight, packedOverlay);
            this.Body.render(poseStack, buffer, packedLight, packedOverlay);
            poseStack.popPose();
        }
        if (this.slot == EquipmentSlot.LEGS) {
            poseStack.pushPose();
            this.RightLeg.copyFrom(this.rightLeg);
            this.LeftLeg.copyFrom(this.leftLeg);
            if (this.young) {
                poseStack.scale(0.5f, 0.5f, 0.5f);
                this.LeftLeg.setPos(2.0f, 36.0f, 0.0f);
                this.RightLeg.setPos(-2.0f, 36.0f, 0.0f);
            }
            this.RightLeg.render(poseStack, buffer, packedLight, packedOverlay);
            this.LeftLeg.render(poseStack, buffer, packedLight, packedOverlay);
            poseStack.popPose();
        }
        if (this.slot == EquipmentSlot.FEET) {
            poseStack.pushPose();
            this.RightBoot.copyFrom(this.rightLeg);
            this.LeftBoot.copyFrom(this.leftLeg);
            if (this.young) {
                poseStack.scale(0.5f, 0.5f, 0.5f);
                this.LeftBoot.setPos(2.0f, 37.0f, 0.0f);
                this.RightBoot.setPos(-2.0f, 37.0f, 0.0f);
            }
            this.RightBoot.render(poseStack, buffer, packedLight, packedOverlay);
            this.LeftBoot.render(poseStack, buffer, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }
}

