/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.client.render.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import galena.oreganized.Oreganized;
import galena.oreganized.OreganizedConfig;
import galena.oreganized.index.OEffects;
import galena.oreganized.index.OFluids;
import io.netty.util.collection.IntObjectHashMap;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.neoforge.fluids.FluidType;

public class StunningOverlay
implements LayeredDraw.Layer {
    protected static final ResourceLocation STUNNING_VIGNETTE_LOCATION = Oreganized.modLoc("textures/misc/stunning_overlay.png");
    private static final IntObjectHashMap<ResourceLocation> STUNNING_OVERLAY_LOCATIONS = new IntObjectHashMap();

    protected static ResourceLocation getStunningOutline(int amplifier) {
        return (ResourceLocation)STUNNING_OVERLAY_LOCATIONS.computeIfAbsent((Object)amplifier, i -> Oreganized.modLoc("textures/misc/brain_damage_outline_" + (i + 1) + ".png"));
    }

    public void render(GuiGraphics graphics, DeltaTracker delta) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        MobEffectInstance stunning = minecraft.player.getEffect(OEffects.STUNNING);
        if (stunning != null && ((Boolean)OreganizedConfig.CLIENT.renderStunningOverlay.get()).booleanValue()) {
            float opacity = (float)stunning.getAmplifier() * 1.0f / 9.0f;
            this.renderTextureOverlay(graphics, STUNNING_VIGNETTE_LOCATION, opacity);
            this.renderTextureOverlay(graphics, StunningOverlay.getStunningOutline(stunning.getAmplifier()), 1.0f);
        }
        if (minecraft.player.isEyeInFluidType((FluidType)OFluids.MOLTEN_LEAD_TYPE.get())) {
            this.renderTextureOverlay(graphics, STUNNING_VIGNETTE_LOCATION, 1.0f);
        }
    }

    private void renderTextureOverlay(GuiGraphics graphics, ResourceLocation texture, float opacity) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, opacity);
        graphics.blit(texture, 0, 0, -90, 0.0f, 0.0f, graphics.guiWidth(), graphics.guiHeight(), graphics.guiWidth(), graphics.guiHeight());
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

