/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.compat;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;

public class ColorCompat {
    public static String getNamespace(DyeColor color) {
        return switch (color) {
            case DyeColor.RED, DyeColor.BLACK, DyeColor.BLUE, DyeColor.BROWN, DyeColor.CYAN, DyeColor.GRAY, DyeColor.LIGHT_BLUE, DyeColor.LIGHT_GRAY, DyeColor.GREEN, DyeColor.LIME, DyeColor.MAGENTA, DyeColor.ORANGE, DyeColor.PINK, DyeColor.PURPLE, DyeColor.WHITE, DyeColor.YELLOW -> "minecraft";
            default -> "dye_depot";
        };
    }

    public static ResourceLocation createId(String suffix, DyeColor color) {
        return ResourceLocation.fromNamespaceAndPath((String)ColorCompat.getNamespace(color), (String)(color.getSerializedName() + "_" + suffix));
    }

    public static ResourceKey<Block> createBlockKey(String suffix, DyeColor color) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ColorCompat.createId(suffix, color));
    }

    public static Block getColoredBlock(String suffix, DyeColor color) {
        return (Block)BuiltInRegistries.BLOCK.getOrThrow(ColorCompat.createBlockKey(suffix, color));
    }
}

