/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.content.block.IMeltableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class BulbBlock
extends Block
implements IMeltableBlock {
    public static final IntegerProperty GOOPYNESS_4 = IntegerProperty.create((String)"goopyness", (int)0, (int)3);

    public static int getLightLevel(BlockState state) {
        return switch ((Integer)state.getValue((Property)GOOPYNESS_4)) {
            case 0 -> 13;
            case 1 -> 8;
            case 2 -> 3;
            default -> 6;
        };
    }

    public BulbBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)GOOPYNESS_4, (Comparable)Integer.valueOf(0)));
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> definition) {
        super.createBlockStateDefinition(definition);
        definition.add(new Property[]{GOOPYNESS_4});
    }

    @Override
    public int getGoopyness(BlockState state) {
        return Math.max(0, (Integer)state.getValue((Property)GOOPYNESS_4) - 1);
    }

    @Override
    public IntegerProperty getGoopynessProperty() {
        return GOOPYNESS_4;
    }

    @Override
    public int getInducedGoopyness(BlockGetter world, BlockState state, BlockPos pos, BlockState selfState, BlockPos selfPos) {
        IMeltableBlock meltable;
        Block block = state.getBlock();
        if (block instanceof IMeltableBlock && (meltable = (IMeltableBlock)block).getGoopyness(state) == 1) {
            return 1;
        }
        int defaultGoopyness = IMeltableBlock.super.getInducedGoopyness(world, state, pos, selfState, selfPos);
        if (defaultGoopyness == 0) {
            return 0;
        }
        return defaultGoopyness + 1;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.tickMelting(state, (Level)world, pos, random);
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        this.hurt(state, world, entity);
        super.stepOn(world, pos, state, entity);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        this.scheduleUpdate(level, pos, block);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.scheduleUpdate(level, pos, state.getBlock());
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        Integer goopyness = (Integer)state.getValue((Property)GOOPYNESS_4);
        return (3 - goopyness) * 5;
    }
}

