/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.content.block.IHeavyDoor;
import galena.oreganized.content.block.IMeltableBlock;
import galena.oreganized.content.block.LeadDoorBlock;
import galena.oreganized.index.OBlockEntities;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.ODamageSources;
import galena.oreganized.world.IDoorProgressHolder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class HeavyDoorBlockEntity
extends BlockEntity {
    private int pressure = 0;
    private final BlockSetType set = OBlocks.LEAD_BLOCK_SET;
    private static final int REQUIRED_PRESSURE_OPEN = 20;

    public HeavyDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)OBlockEntities.HEAVY_DOOR.get(), pos, state);
    }

    public static Optional<HeavyDoorBlockEntity> getAt(LevelAccessor level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof HeavyDoorBlockEntity) {
            HeavyDoorBlockEntity door = (HeavyDoorBlockEntity)be;
            return Optional.of(door);
        }
        return Optional.empty();
    }

    @Nullable
    public static <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (type == OBlockEntities.HEAVY_DOOR.get()) {
            BlockEntityTicker ticker = (l, p, s, be) -> be.tick(s, l, p);
            return ticker;
        }
        return null;
    }

    public void tick(BlockState state, Level level, BlockPos pos) {
        if (this.pressure <= 0) {
            return;
        }
        --this.pressure;
        if (this.pressure == 0) {
            if (((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
                state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false));
                level.setBlock(pos, state, 10);
                level.gameEvent((Holder)GameEvent.BLOCK_CLOSE, pos, GameEvent.Context.of((BlockState)state));
                Block block = state.getBlock();
                if (block instanceof IHeavyDoor) {
                    IHeavyDoor heavy = (IHeavyDoor)block;
                    heavy.sound(null, level, pos, false);
                }
            }
            this.stopUsing(state, level, pos, null);
        } else if (this.pressure < 15) {
            this.setAnimationState(level, pos, state, true);
        }
    }

    private void setAnimationState(Level level, BlockPos pos, BlockState state, boolean animationState) {
        if (state.hasProperty((Property)LeadDoorBlock.ANIMATED) && (Boolean)state.getValue((Property)LeadDoorBlock.ANIMATED) != animationState) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LeadDoorBlock.ANIMATED, (Comparable)Boolean.valueOf(animationState)));
        }
    }

    private void stopUsing(BlockState state, Level level, BlockPos pos, @Nullable Player player) {
        this.setAnimationState(level, pos, state, false);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.saveAdditional(nbt, lookup);
        nbt.putInt("Pressure", this.pressure);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.loadAdditional(nbt, lookup);
        if (nbt.contains("Pressure", 99)) {
            this.pressure = nbt.getInt("Pressure");
        }
    }

    public ItemInteractionResult use(BlockState state, Level level, BlockPos pos, Player player) {
        IDoorProgressHolder progressHolder = (IDoorProgressHolder)player;
        progressHolder.oreganised$incrementOpeningProgress();
        Block block = state.getBlock();
        if (block instanceof IMeltableBlock) {
            IMeltableBlock meltable = (IMeltableBlock)block;
            int goopyness = meltable.getGoopyness(state);
            if (goopyness > 0) {
                player.hurt(level.damageSources().source(ODamageSources.MOLTEN_LEAD), 1.0f);
            }
            if (goopyness > 1) {
                return ItemInteractionResult.FAIL;
            }
        }
        if (this.pressure == 0) {
            this.setAnimationState(level, pos, state, true);
        }
        if (this.pressure < 20) {
            this.pressure += 6;
        }
        if (this.pressure > 20 && !((Boolean)state.getValue((Property)BlockStateProperties.OPEN)).booleanValue()) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos, state, 10);
            level.gameEvent((Holder)GameEvent.BLOCK_OPEN, pos, GameEvent.Context.of((BlockState)state));
            block = state.getBlock();
            if (block instanceof IHeavyDoor) {
                IHeavyDoor heavy = (IHeavyDoor)block;
                heavy.sound(player, level, pos, true);
            }
            this.stopUsing(state, level, pos, player);
        }
        return ItemInteractionResult.FAIL;
    }
}

