/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.content.block.HeavyDoorBlockEntity;
import galena.oreganized.content.block.IHeavyDoor;
import galena.oreganized.content.block.IMeltableBlock;
import galena.oreganized.index.OBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class LeadDoorBlock
extends DoorBlock
implements IMeltableBlock,
EntityBlock,
IHeavyDoor {
    public static final BooleanProperty ANIMATED = BooleanProperty.create((String)"animated");

    public LeadDoorBlock(BlockBehaviour.Properties properties) {
        super(OBlocks.LEAD_BLOCK_SET, properties);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            return null;
        }
        return new HeavyDoorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return HeavyDoorBlockEntity.getTicker(level, state, type);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos controller = state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? pos.below() : pos;
        return HeavyDoorBlockEntity.getAt((LevelAccessor)level, controller).map(it -> it.use(state, level, pos, player)).orElse(ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{this.getGoopynessProperty()});
    }

    @Override
    public int getNextGoopyness(BlockGetter world, BlockState selfState, BlockPos selfPos) {
        int self = this.goopynessAt(world, selfState, selfPos);
        DoubleBlockHalf half = (DoubleBlockHalf)selfState.getValue((Property)HALF);
        BlockPos otherPos = half == DoubleBlockHalf.LOWER ? selfPos.above() : selfPos.below();
        BlockState otherState = world.getBlockState(otherPos);
        int other = this.goopynessAt(world, otherState, otherPos);
        return Math.max(self, other);
    }

    @Override
    public int getInducedGoopyness(BlockGetter world, BlockState state, BlockPos pos, BlockState selfState, BlockPos selfPos) {
        DoubleBlockHalf selfHalf;
        if (state.is((Block)this) && ((selfHalf = (DoubleBlockHalf)selfState.getValue((Property)HALF)) == DoubleBlockHalf.UPPER && pos.getY() < selfPos.getY() || selfHalf == DoubleBlockHalf.LOWER && pos.getY() > selfPos.getY())) {
            return 0;
        }
        return IMeltableBlock.super.getInducedGoopyness(world, state, pos, selfState, selfPos);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        this.tickMelting(state, (Level)world, pos, random);
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        this.hurt(state, world, entity);
        super.stepOn(world, pos, state, entity);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        this.scheduleUpdate(level, pos, block);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        this.scheduleUpdate(level, pos, state.getBlock());
    }

    @Override
    public void sound(@Nullable Player player, Level level, BlockPos pos, boolean open) {
        this.playSound((Entity)player, level, pos, open);
    }
}

