/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.entity;

import galena.oreganized.content.block.GargoyleBlock;
import galena.oreganized.content.critera.DummyCriterionTrigger;
import galena.oreganized.index.OBlockEntities;
import galena.oreganized.index.OCriteriaTriggers;
import galena.oreganized.index.OParticleTypes;
import galena.oreganized.index.OSoundEvents;
import galena.oreganized.index.OTags;
import galena.oreganized.network.packet.GargoyleParticlePacket;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class GargoyleBlockEntity
extends BlockEntity {
    private static final int COOLDOWN = 600;
    public static final String GROWL_COOLDOWN_TAG = "oreganized:gargoyle_use_cooldown";
    private int outputSignal = 0;
    private int updateCooldown = 0;
    private int growlCooldown = 0;
    private ParticleOptions drippingFluid;
    private final Direction fluidOffset;

    public GargoyleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)OBlockEntities.GARGOYLE.get(), pos, state);
        GargoyleBlock.AttachmentType attachment = (GargoyleBlock.AttachmentType)((Object)state.getValue(GargoyleBlock.ATTACHMENT));
        Direction facing = (Direction)state.getValue((Property)GargoyleBlock.FACING);
        this.fluidOffset = attachment == GargoyleBlock.AttachmentType.FLOOR ? Direction.DOWN : facing;
    }

    private static Collection<Mob> getTargets(Level level, BlockPos pos) {
        AABB box = new AABB(pos).inflate(10.0);
        return level.getEntitiesOfClass(Mob.class, box, it -> it.getType().is(OTags.Entities.SCARED_OF_GARGOYLE));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GargoyleBlockEntity be) {
        --be.growlCooldown;
        if (be.updateCooldown % 2 == 0 && be.drippingFluid != null) {
            GargoyleBlock.dripParticles(state, level, pos, level.random, be.drippingFluid);
        }
        if (--be.updateCooldown > 0) {
            return;
        }
        be.updateDripParticles(level, pos, state);
        Collection<Mob> targets = GargoyleBlockEntity.getTargets(level, pos);
        Vec3 vec = Vec3.atCenterOf((Vec3i)pos);
        double closestDistance = targets.stream().mapToDouble(it -> it.distanceToSqr(vec)).map(Math::sqrt).map(Math::floor).sorted().findFirst().orElse(100.0);
        int newOutputSignal = Math.max(14 - (int)closestDistance, 0);
        if (newOutputSignal != be.outputSignal) {
            be.outputSignal = newOutputSignal;
            level.updateNeighbourForOutputSignal(pos, be.getBlockState().getBlock());
        }
        be.updateCooldown = 10;
    }

    private void updateDripParticles(Level level, BlockPos pos, BlockState state) {
        for (int i = 1; i <= 2; ++i) {
            BlockPos targetPos = pos.relative(this.fluidOffset, i);
            BlockState targetState = level.getBlockState(targetPos);
            FluidState fluid = targetState.getFluidState();
            if (!fluid.isEmpty()) {
                this.drippingFluid = fluid.getDripParticle();
                if (fluid.is((Fluid)Fluids.WATER)) {
                    level.getEntitiesOfClass(ServerPlayer.class, new AABB(pos).inflate(10.0, 5.0, 10.0)).forEach(player -> ((DummyCriterionTrigger)((Object)((Object)OCriteriaTriggers.SEE_GARGOYLE_GARGLE.get()))).trigger((ServerPlayer)player));
                }
                return;
            }
            if (!targetState.isRedstoneConductor((BlockGetter)level, pos) || !targetState.isFaceSturdy((BlockGetter)level, pos, Direction.UP) || !targetState.isFaceSturdy((BlockGetter)level, pos, Direction.DOWN)) break;
        }
        this.drippingFluid = level.isRainingAt(pos.above()) ? ParticleTypes.DRIPPING_DRIPSTONE_WATER : null;
    }

    public int getAnalogOutputSignal() {
        return this.outputSignal;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("cooldown", this.growlCooldown);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        if (tag.contains("cooldown")) {
            this.growlCooldown = tag.getInt("cooldown");
        }
    }

    public ItemInteractionResult interact(Level level, BlockPos pos, @Nullable Player player, ItemStack stack, boolean simulate) {
        if (!stack.is(OTags.Items.GARGOYLE_SNACK)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (player != null && player.getPersistentData().getInt(GROWL_COOLDOWN_TAG) > 0) {
            return ItemInteractionResult.FAIL;
        }
        if (this.growlCooldown > 0) {
            return ItemInteractionResult.FAIL;
        }
        if (player == null || !player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        if (simulate) {
            return ItemInteractionResult.SUCCESS;
        }
        GargoyleBlockEntity.getTargets(level, pos).forEach(mob -> this.scare((Entity)mob, pos));
        level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (SoundEvent)OSoundEvents.GARGOYLE_GROWL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.growlCooldown = 600;
        if (player != null && !player.getAbilities().instabuild) {
            player.getPersistentData().putInt(GROWL_COOLDOWN_TAG, 600);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersInDimension((ServerLevel)serverLevel, (CustomPacketPayload)new GargoyleParticlePacket(pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return ItemInteractionResult.SUCCESS;
    }

    private void scare(Entity mob, BlockPos pos) {
        Vec3 offset = mob.position().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (offset.length() < 4.0) {
            Vec3 motion = offset.multiply(0.4, 0.2, 0.4);
            mob.push(motion.x, motion.y, motion.z);
        }
        mob.getPersistentData().put("ScaredByGargoyle", NbtUtils.writeBlockPos((BlockPos)pos));
    }

    public void spawnParticles() {
        BlockPos pos = this.getBlockPos();
        BlockState state = this.getBlockState();
        Direction facing = (Direction)state.getValue((Property)GargoyleBlock.FACING);
        GargoyleBlock.AttachmentType attachment = (GargoyleBlock.AttachmentType)((Object)state.getValue(GargoyleBlock.ATTACHMENT));
        ParticleUtils.spawnParticlesOnBlockFaces((Level)this.level, (BlockPos)pos, (ParticleOptions)((ParticleOptions)OParticleTypes.VENGEANCE.get()), (IntProvider)UniformInt.of((int)0, (int)2));
        if (attachment == GargoyleBlock.AttachmentType.WALL) {
            ParticleUtils.spawnParticlesOnBlockFaces((Level)this.level, (BlockPos)pos.relative(facing.getOpposite()), (ParticleOptions)((ParticleOptions)OParticleTypes.VENGEANCE.get()), (IntProvider)UniformInt.of((int)0, (int)1));
        }
    }
}

