/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.entity;

import galena.oreganized.content.critera.DummyCriterionTrigger;
import galena.oreganized.index.OCriteriaTriggers;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OSoundEvents;
import galena.oreganized.index.OTags;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LeadBoltEntity
extends AbstractArrow {
    private static boolean canShootOff(ItemStack stack, LivingEntity entity) {
        if (entity.getType().is(OTags.Entities.BOLT_RESISTANT)) {
            return false;
        }
        if (stack.isEmpty()) {
            return false;
        }
        return !EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE);
    }

    @Nullable
    private static EquipmentSlot randomSlot(LivingEntity entity) {
        List<EquipmentSlot> slots;
        if (entity.isUsingItem()) {
            InteractionHand hand = entity.getUsedItemHand();
            ItemStack using = entity.getItemInHand(hand);
            if (!LeadBoltEntity.canShootOff(using, entity)) {
                return null;
            }
            if (using.getItem() instanceof ShieldItem) {
                return switch (hand) {
                    default -> throw new MatchException(null, null);
                    case InteractionHand.OFF_HAND -> EquipmentSlot.OFFHAND;
                    case InteractionHand.MAIN_HAND -> EquipmentSlot.MAINHAND;
                };
            }
        }
        if ((slots = Stream.of(EquipmentSlot.CHEST, EquipmentSlot.FEET, EquipmentSlot.HEAD, EquipmentSlot.LEGS).filter(it -> LeadBoltEntity.canShootOff(entity.getItemBySlot(it), entity)).toList()).isEmpty()) {
            return null;
        }
        return slots.get(entity.getRandom().nextInt(0, slots.size()));
    }

    public LeadBoltEntity(EntityType<? extends LeadBoltEntity> type, Level level) {
        super(type, level);
    }

    public LeadBoltEntity(EntityType<? extends LeadBoltEntity> type, Level level, Position pos, ItemStack stack) {
        super(type, pos.x(), pos.y(), pos.z(), level, stack, null);
    }

    public LeadBoltEntity(EntityType<? extends LeadBoltEntity> type, Level level, LivingEntity user, ItemStack stack, @Nullable ItemStack weapon) {
        super(type, user, level, stack, weapon);
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)OItems.LEAD_BOLT.get());
    }

    private void damageEntity(EntityHitResult result) {
        ItemStack knockedOff;
        LivingEntity living;
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).getRandom().nextDouble() < 0.1 && (knockedOff = this.knockOff(living)) != null) {
            Vec3 vec = result.getLocation();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, vec.x, vec.y + 2.0, vec.z, 4, 0.1, 0.1, 0.1, 0.0);
            }
            this.playSound((SoundEvent)OSoundEvents.BOLT_HIT_ARMOR.get(), 1.5f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            level = knockedOff.getItem();
            if (level instanceof Equipable) {
                Equipable item = (Equipable)level;
                this.playSound((SoundEvent)item.getEquipSound().value());
            }
            if (result.getEntity() instanceof Pillager && knockedOff.is(ItemTags.BANNERS) && (level = this.getOwner()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)level;
                ((DummyCriterionTrigger)((Object)OCriteriaTriggers.KNOCKED_BANNER_OFF.get())).trigger(player);
            }
            this.discard();
            return;
        }
        super.onHitEntity(result);
    }

    protected void onHitEntity(EntityHitResult result) {
        int n;
        this.setSoundEvent((SoundEvent)OSoundEvents.BOLT_HIT.get());
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            n = living.getArrowCount();
        } else {
            n = 0;
        }
        int arrowCount = n;
        double baseDamage = 3.0;
        this.setBaseDamage(baseDamage);
        if (result.getEntity().getType() == EntityType.IRON_GOLEM) {
            this.setBaseDamage(baseDamage * 3.0);
        }
        this.damageEntity(result);
        this.setBaseDamage(baseDamage);
        Entity entity2 = result.getEntity();
        if (entity2 instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity2;
            living.setArrowCount(arrowCount);
        }
    }

    protected void onHitBlock(BlockHitResult result) {
        this.setSoundEvent((SoundEvent)OSoundEvents.BOLT_HIT.get());
        super.onHitBlock(result);
    }

    private ItemStack knockOff(LivingEntity entity) {
        EquipmentSlot slot = LeadBoltEntity.randomSlot(entity);
        if (slot == null) {
            return null;
        }
        ItemStack stack = entity.getItemBySlot(slot);
        if (!EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) {
            if (entity instanceof Mob && stack.isDamageableItem()) {
                stack.setDamageValue(stack.getMaxDamage() - this.random.nextInt(1 + this.random.nextInt(Math.max(stack.getMaxDamage() - 3, 1))));
            }
            ItemEntity item = new ItemEntity(entity.level(), entity.getX(), entity.getY(), entity.getZ(), stack);
            item.setPickUpDelay(40);
            this.level().addFreshEntity((Entity)item);
        }
        entity.setItemSlot(slot, ItemStack.EMPTY);
        return stack;
    }

    public void shootFromRotation(Entity user, float p_37253_, float p_37254_, float p_37255_, float p_37256_, float p_37257_) {
        super.shootFromRotation(user, p_37253_, p_37254_, p_37255_, p_37256_ * 0.5f, p_37257_);
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)OItems.LEAD_BOLT.get());
    }
}

