/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.entity;

import com.mojang.logging.annotations.MethodsReturnNonnullByDefault;
import galena.oreganized.OreganizedConfig;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.ODamageSources;
import galena.oreganized.index.OEffects;
import galena.oreganized.index.OEntityTypes;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OParticleTypes;
import galena.oreganized.index.OSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MinecartShrapnelBomb
extends AbstractMinecart {
    private static final byte EVENT_PRIME = 10;
    private int fuse = -1;

    public MinecartShrapnelBomb(EntityType<? extends MinecartShrapnelBomb> entityType, Level world) {
        super(entityType, world);
    }

    public MinecartShrapnelBomb(Level world, double x, double y, double z) {
        super((EntityType)OEntityTypes.SHRAPNEL_BOMB_MINECART.get(), world, x, y, z);
    }

    public AbstractMinecart.Type getMinecartType() {
        return AbstractMinecart.Type.TNT;
    }

    public BlockState getDefaultDisplayBlockState() {
        return ((Block)OBlocks.SHRAPNEL_BOMB.get()).defaultBlockState();
    }

    public void tick() {
        double d0;
        super.tick();
        if (this.fuse > 0) {
            --this.fuse;
            this.level().addParticle((ParticleOptions)ParticleTypes.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        } else if (this.fuse == 0) {
            this.explode(this.getDeltaMovement().horizontalDistanceSqr());
        }
        if (this.horizontalCollision && (d0 = this.getDeltaMovement().horizontalDistanceSqr()) >= (double)0.01f) {
            this.explode(d0);
        }
    }

    public boolean hurt(DamageSource p_38666_, float p_38667_) {
        AbstractArrow abstractarrow;
        Entity entity = p_38666_.getDirectEntity();
        if (entity instanceof AbstractArrow && (abstractarrow = (AbstractArrow)entity).isOnFire()) {
            this.explode(abstractarrow.getDeltaMovement().lengthSqr());
        }
        return super.hurt(p_38666_, p_38667_);
    }

    public void destroy(DamageSource source) {
        double d0 = this.getDeltaMovement().horizontalDistanceSqr();
        if (!(source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypeTags.IS_EXPLOSION) || d0 >= (double)0.01f)) {
            super.destroy(source);
        } else if (this.fuse < 0) {
            this.primeFuse();
            this.fuse = this.random.nextInt(20) + this.random.nextInt(20);
        }
    }

    protected Item getDropItem() {
        return (Item)OItems.SHRAPNEL_BOMB_MINECART.get();
    }

    protected void explode(double p_38689_) {
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 4.0f, Level.ExplosionInteraction.NONE);
        if (!this.level().isClientSide()) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)((SimpleParticleType)OParticleTypes.LEAD_SHRAPNEL.get()), this.getX(), this.getY(0.0625), this.getZ(), 100, 0.0, 0.0, 0.0, 5.0);
        }
        for (Entity entity : this.level().getEntities((Entity)this, new AABB(this.getX() - 30.0, this.getY() - 4.0, this.getZ() - 30.0, this.getX() + 30.0, this.getY() + 4.0, this.getZ() + 30.0))) {
            int random = (int)(Math.random() * 100.0);
            boolean shouldPoison = false;
            if (entity.distanceToSqr((Entity)this) <= 16.0) {
                shouldPoison = true;
            } else if (entity.distanceToSqr((Entity)this) <= 64.0) {
                if (random < 60) {
                    shouldPoison = true;
                }
            } else if (entity.distanceToSqr((Entity)this) <= 225.0) {
                if (random < 30) {
                    shouldPoison = true;
                }
            } else if (entity.distanceToSqr((Entity)this) <= 900.0 && random < 5) {
                shouldPoison = true;
            }
            if (!shouldPoison || !(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            living.hurt(this.damageSources().source(ODamageSources.LEAD_POISONING), 2.0f);
            living.addEffect(new MobEffectInstance(MobEffects.POISON, 260));
            if (((Boolean)OreganizedConfig.COMMON.poisonInsteadOfStunning.get()).booleanValue()) continue;
            living.addEffect(new MobEffectInstance(OEffects.STUNNING, 800));
        }
        this.discard();
    }

    public boolean causeFallDamage(float p_150347_, float p_150348_, DamageSource p_150349_) {
        if (p_150347_ >= 3.0f) {
            float f = p_150347_ / 10.0f;
            this.explode(f * f);
        }
        return super.causeFallDamage(p_150347_, p_150348_, p_150349_);
    }

    public void activateMinecart(int p_38659_, int p_38660_, int p_38661_, boolean p_38662_) {
        if (p_38662_ && this.fuse < 0) {
            this.primeFuse();
        }
    }

    public void handleEntityEvent(byte p_38657_) {
        if (p_38657_ == 10) {
            this.primeFuse();
        } else {
            super.handleEntityEvent(p_38657_);
        }
    }

    public void primeFuse() {
        this.fuse = 80;
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)10);
            if (!this.isSilent()) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (SoundEvent)OSoundEvents.SHRAPNEL_BOMB_PRIMED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public int getFuse() {
        return this.fuse;
    }

    public boolean isPrimed() {
        return this.fuse > -1;
    }

    public float getBlockExplosionResistance(Explosion p_38675_, BlockGetter p_38676_, BlockPos p_38677_, BlockState p_38678_, FluidState p_38679_, float p_38680_) {
        return !this.isPrimed() || !p_38678_.is(BlockTags.RAILS) && !p_38676_.getBlockState(p_38677_.above()).is(BlockTags.RAILS) ? super.getBlockExplosionResistance(p_38675_, p_38676_, p_38677_, p_38678_, p_38679_, p_38680_) : 0.0f;
    }

    public boolean shouldBlockExplode(Explosion p_38669_, BlockGetter p_38670_, BlockPos p_38671_, BlockState p_38672_, float p_38673_) {
        return (!this.isPrimed() || !p_38672_.is(BlockTags.RAILS) && !p_38670_.getBlockState(p_38671_.above()).is(BlockTags.RAILS)) && super.shouldBlockExplode(p_38669_, p_38670_, p_38671_, p_38672_, p_38673_);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        if (nbt.contains("ShrapnelBombFuse", 99)) {
            this.fuse = nbt.getInt("ShrapnelBombFuse");
        }
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putInt("ShrapnelBombFuse", this.fuse);
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)OItems.SHRAPNEL_BOMB_MINECART.get());
    }
}

