/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.entity;

import galena.oreganized.OreganizedConfig;
import galena.oreganized.api.LeadProtections;
import galena.oreganized.index.ODamageSources;
import galena.oreganized.index.OEffects;
import galena.oreganized.index.OEntityTypes;
import galena.oreganized.index.OParticleTypes;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ShrapnelBomb
extends PrimedTnt {
    public ShrapnelBomb(EntityType<? extends PrimedTnt> entity, Level world) {
        super(entity, world);
    }

    public ShrapnelBomb(Level world, double x, double y, double z, @Nullable LivingEntity igniterEntity) {
        this((EntityType<? extends PrimedTnt>)((EntityType)OEntityTypes.SHRAPNEL_BOMB.get()), world);
        this.setPos(x, y, z);
        double delta = world.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(delta) * 0.02, 0.2f, -Math.cos(delta) * 0.02);
        this.setFuse(80);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.owner = igniterEntity;
    }

    protected void explode() {
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), 4.0f, Level.ExplosionInteraction.NONE);
        if (!this.level().isClientSide()) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)((SimpleParticleType)OParticleTypes.LEAD_SHRAPNEL.get()), this.getX(), this.getY(0.0625), this.getZ(), 100, 0.0, 0.0, 0.0, 5.0);
        }
        for (Entity entity : this.level().getEntities((Entity)this, new AABB(this.getX() - 30.0, this.getY() - 4.0, this.getZ() - 30.0, this.getX() + 30.0, this.getY() + 4.0, this.getZ() + 30.0))) {
            int random = (int)(Math.random() * 100.0);
            boolean shouldPoison = false;
            if (entity.distanceToSqr((Entity)this) <= 16.0) {
                shouldPoison = true;
            } else if (entity.distanceToSqr((Entity)this) <= 64.0) {
                if (random < 60) {
                    shouldPoison = true;
                }
            } else if (entity.distanceToSqr((Entity)this) <= 225.0) {
                if (random < 30) {
                    shouldPoison = true;
                }
            } else if (entity.distanceToSqr((Entity)this) <= 900.0 && random < 5) {
                shouldPoison = true;
            }
            if (!shouldPoison || !(entity instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)entity;
            living.hurt(this.damageSources().source(ODamageSources.LEAD_POISONING), 2.0f);
            if (!LeadProtections.isNotProtected(living)) continue;
            living.addEffect(new MobEffectInstance(MobEffects.POISON, 260));
            if (((Boolean)OreganizedConfig.COMMON.poisonInsteadOfStunning.get()).booleanValue()) continue;
            living.addEffect(new MobEffectInstance(OEffects.STUNNING, 800));
        }
    }
}

