/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.item;

import galena.oreganized.content.block.LeadOreBlock;
import galena.oreganized.index.OParticleTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FlintAndPewterItem
extends Item {
    public FlintAndPewterItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        if (level.isWaterAt(pos)) {
            return InteractionResult.FAIL;
        }
        level.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.4f + 0.4f);
        AreaEffectCloud cloud = LeadOreBlock.spawnCloud(level, pos, 1.0f);
        cloud.setWaitTime(0);
        Vec3 vec = context.getClickLocation();
        for (int i = 0; i < 6; ++i) {
            level.addParticle((ParticleOptions)OParticleTypes.LEAD_BLOW.get(), vec.x, vec.y, vec.z, level.random.nextDouble() * 0.2 - 0.1, level.random.nextDouble() * 0.2 - 0.1, level.random.nextDouble() * 0.2 - 0.1);
        }
        if (player != null) {
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }
}

