/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.item;

import galena.oreganized.OreganizedConfig;
import galena.oreganized.content.block.ICrystalGlass;
import galena.oreganized.index.ORecipeTypes;
import galena.oreganized.index.OTags;
import galena.oreganized.world.recipe.BlockRecipeInput;
import galena.oreganized.world.recipe.ScribeRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class ScribeItem
extends Item {
    public ScribeItem(Item.Properties properties) {
        super(properties);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity user) {
        if (!level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            stack.hurtAndBreak(1, user, LivingEntity.getSlotForHand((InteractionHand)user.getUsedItemHand()));
        }
        return true;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.is(OTags.Blocks.MINEABLE_WITH_SCRIBE)) {
            return 32.0f;
        }
        if (this.isCorrectToolForDrops(stack, state)) {
            return 0.3f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean dropsLikeSilktouch(ItemStack stack, BlockState state) {
        return this.isCorrectToolForDrops(stack, state) && !this.shouldNotSilktouch(stack, state);
    }

    private boolean shouldNotSilktouch(ItemStack stack, BlockState state) {
        return state.is(OTags.Blocks.SILKTOUCH_WITH_SCRIBE_BLACKLIST);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (((Boolean)OreganizedConfig.COMMON.scribeSilkTouchStone.get()).booleanValue()) {
            return state.is(OTags.Blocks.SILKTOUCH_WITH_SCRIBE);
        }
        return state.is(OTags.Blocks.MINEABLE_WITH_SCRIBE);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairStack) {
        return repairStack.is(Items.AMETHYST_SHARD);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(EnchantmentTags.MINING_EXCLUSIVE)) {
            return true;
        }
        return super.supportsEnchantment(stack, enchantment);
    }

    private InteractionResult replaceBlock(UseOnContext context, BlockState to, boolean particles) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState from = level.getBlockState(pos);
        level.setBlockAndUpdate(pos, to);
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)context.getPlayer(), (BlockState)from));
        if (particles) {
            level.addDestroyBlockEffect(pos, from);
        }
        if (context.getPlayer() != null) {
            context.getPlayer().playSound(SoundEvents.GRINDSTONE_USE, 1.0f, 1.5f);
            context.getItemInHand().hurtAndBreak(1, (LivingEntity)context.getPlayer(), LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.hasProperty((Property)ICrystalGlass.TYPE)) {
            Integer type = (Integer)state.getValue((Property)ICrystalGlass.TYPE);
            return this.replaceBlock(context, (BlockState)state.setValue((Property)ICrystalGlass.TYPE, (Comparable)Integer.valueOf((type + 1) % 4)), true);
        }
        BlockRecipeInput input = new BlockRecipeInput(new BlockInWorld((LevelReader)context.getLevel(), context.getClickedPos(), false));
        ScribeRecipe recipe = context.getLevel().getRecipeManager().getRecipeFor((RecipeType)ORecipeTypes.SCRIBE_RECIPE.get(), (RecipeInput)input, context.getLevel()).map(RecipeHolder::value).orElse(null);
        if (recipe != null) {
            if (recipe.dropResources()) {
                ItemStack tool = new ItemStack((ItemLike)Items.IRON_PICKAXE);
                tool.applyComponents(context.getItemInHand().getComponents());
                Block.dropResources((BlockState)state, (Level)context.getLevel(), (BlockPos)context.getClickedPos(), null, (Entity)context.getPlayer(), (ItemStack)tool);
            }
            return this.replaceBlock(context, recipe.to().withPropertiesOf(state), !recipe.dropResources());
        }
        return super.useOn(context);
    }
}

