/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.item;

import galena.oreganized.Oreganized;
import galena.oreganized.client.accessors.GuiAccessor;
import galena.oreganized.client.tooltips.ThermometerTooltip;
import galena.oreganized.content.block.IMeltableBlock;
import galena.oreganized.content.critera.DummyCriterionTrigger;
import galena.oreganized.index.OCriteriaTriggers;
import galena.oreganized.index.ODataComponents;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="oreganized")
public class ThermometerItem
extends Item {
    public static final ResourceKey<LootTable> BREAK_LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Oreganized.modLoc("gameplay/thermometer_breaking"));
    private static final int AMBIENT_RANGE = 5;
    public static final int HEAT_LEVELS = 9;

    public ThermometerItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        int heat = ThermometerItem.getHeatLevel(stack);
        return Optional.of(new ThermometerTooltip(heat));
    }

    private static int heatLevel(BlockState state, LevelAccessor level, BlockPos pos) {
        if (state.is(OTags.Blocks.LAVA_HEAT_LEVEL)) {
            return 8;
        }
        if (state.is(OTags.Blocks.FIRE_HEAT_LEVEL)) {
            return 7;
        }
        if (state.getLightEmission((BlockGetter)level, pos) > 2) {
            return 4;
        }
        Block block = state.getBlock();
        if (block instanceof IMeltableBlock) {
            IMeltableBlock block2 = (IMeltableBlock)block;
            int goopyness = block2.getGoopyness(state);
            if (goopyness > 1) {
                return 7;
            }
            if (goopyness > 0) {
                return 5;
            }
        }
        return 2;
    }

    public static int ambientMeasurement(Player player) {
        Level level = player.level();
        BlockPos pos = player.blockPosition();
        if (player.getBlockStateOn().is(OTags.Blocks.LAVA_HEAT_LEVEL)) {
            return 8;
        }
        if (player.getBlockStateOn().is(OTags.Blocks.FIRE_HEAT_LEVEL)) {
            return 7;
        }
        if (player.isOnFire()) {
            return 5;
        }
        if (player.isFreezing()) {
            return 0;
        }
        Biome biome = (Biome)level.getBiome(pos).value();
        float temperature = biome.getBaseTemperature();
        int weather = level.isRaining() ? 0 : 1;
        return (int)(Math.max(0.0f, Math.min(2.0f, temperature) / 2.0f) * 3.0f) + weather;
    }

    public static int activeMeasurement(Level level, BlockPos pos) {
        int lavaHeatLevel;
        AABB box = new AABB(pos).inflate(5.0);
        int lavaDistance = BlockPos.betweenClosedStream((AABB)box).filter(it -> level.getBlockState(it).is(OTags.Blocks.LAVA_HEAT_LEVEL)).mapToInt(it -> it.distManhattan((Vec3i)pos)).min().orElse(Integer.MAX_VALUE);
        BlockState state = level.getBlockState(pos);
        int blockHeatLevel = ThermometerItem.heatLevel(state, (LevelAccessor)level, pos);
        if (lavaDistance < 9 && (lavaHeatLevel = 8 - lavaDistance) > blockHeatLevel) {
            return lavaHeatLevel;
        }
        return blockHeatLevel;
    }

    private static int heatLevel(LivingEntity entity) {
        if (entity.getType() == EntityType.MAGMA_CUBE) {
            return 8;
        }
        if (entity.getType() == EntityType.BLAZE) {
            return 7;
        }
        if (entity.isOnFire()) {
            return 5;
        }
        if (entity.isInvertedHealAndHarm()) {
            return 1;
        }
        if (entity.getActiveEffects().stream().anyMatch(it -> !((MobEffect)it.getEffect().value()).isBeneficial())) {
            return 3;
        }
        return 2;
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        ItemStack held = player.getItemInHand(hand);
        int heatLevel = ThermometerItem.heatLevel(target);
        ThermometerItem.setHeatLevel(held, player.level(), heatLevel);
        player.getCooldowns().addCooldown(held.getItem(), 60);
        ThermometerItem.setLocked((Entity)player, held, true);
        return InteractionResult.sidedSuccess((boolean)player.level().isClientSide());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        InteractionResultHolder<ItemStack> result;
        BlockHitResult hit = ThermometerItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hit.getType() != HitResult.Type.BLOCK) {
            return super.use(level, player, hand);
        }
        BlockPos pos = hit.getBlockPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = player.getItemInHand(hand);
        if (state.getFluidState().is(FluidTags.WATER) && (result = ThermometerItem.extinguish(player, stack, hit.getLocation())).getResult() != InteractionResult.PASS) {
            return result;
        }
        int heatLevel = ThermometerItem.activeMeasurement(level, pos);
        ThermometerItem.setHeatLevel(stack, level, heatLevel);
        player.getCooldowns().addCooldown(stack.getItem(), 60);
        ThermometerItem.setLocked((Entity)player, stack, true);
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
    }

    private static InteractionResultHolder<ItemStack> extinguish(Player player, ItemStack stack, Vec3 pos) {
        int heatLevel = ThermometerItem.getHeatLevel(stack);
        if (heatLevel < 4) {
            return InteractionResultHolder.pass((Object)stack);
        }
        player.playSound(SoundEvents.FIRE_EXTINGUISH, 1.0f, 0.9f);
        player.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, pos.x(), pos.y(), pos.z(), 0.0, 0.05, 0.0);
        if (heatLevel > 6) {
            stack.shrink(1);
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                LootTable lootTable = level2.getServer().reloadableRegistries().getLootTable(BREAK_LOOT_TABLE);
                LootParams lootParams = new LootParams.Builder(level2).withParameter(LootContextParams.ORIGIN, (Object)pos).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.TOOL, (Object)stack).create(LootContextParamSets.GIFT);
                ObjectArrayList drops = lootTable.getRandomItems(lootParams);
                drops.forEach(drop -> {
                    if (player.addItem(drop)) {
                        return;
                    }
                    Containers.dropItemStack((Level)level2, (double)pos.x(), (double)pos.y(), (double)pos.z(), (ItemStack)drop);
                });
                ((DummyCriterionTrigger)((Object)OCriteriaTriggers.BROKEN_THERMOMETER.get())).trigger((ServerPlayer)player);
            }
        } else {
            ThermometerItem.setLocked((Entity)player, stack, false);
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)player.level().isClientSide());
    }

    public InteractionResult useOn(UseOnContext context) {
        return InteractionResult.PASS;
    }

    public static int getHeatLevel(ItemStack stack) {
        return (Integer)stack.getOrDefault(ODataComponents.HEAT_LEVEL, (Object)0);
    }

    public static void setHeatLevel(ItemStack stack, @Nullable Level level, int heatLevel) {
        Gui gui;
        if (ThermometerItem.getHeatLevel(stack) == heatLevel) {
            return;
        }
        stack.set(ODataComponents.HEAT_LEVEL, (Object)heatLevel);
        if (level != null && level.isClientSide() && (gui = Minecraft.getInstance().gui) instanceof GuiAccessor) {
            GuiAccessor accessor = (GuiAccessor)gui;
            accessor.oreganized$setToolHighlightTimer(60);
        }
    }

    public static boolean isLocked(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ODataComponents.LOCKED, (Object)false);
    }

    private static void setLocked(@Nullable Entity user, ItemStack stack, boolean locked) {
        SoundEvent sound;
        if (ThermometerItem.isLocked(stack) == locked) {
            return;
        }
        stack.set(ODataComponents.LOCKED, (Object)locked);
        SoundEvent soundEvent = sound = locked ? SoundEvents.LODESTONE_COMPASS_LOCK : SoundEvents.AMETHYST_BLOCK_RESONATE;
        if (user != null) {
            user.level().playSound(user, user.blockPosition(), sound, SoundSource.PLAYERS, 1.0f, 1.2f);
        }
    }

    @SubscribeEvent
    public static void onHitAir(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack = event.getItemStack();
        if (!stack.is((Item)OItems.THERMOMETER.get())) {
            return;
        }
        ThermometerItem.setLocked((Entity)event.getEntity(), stack, false);
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ((DummyCriterionTrigger)((Object)OCriteriaTriggers.SHAKEN_THERMOMETER.get())).trigger(player2);
        }
    }
}

