/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data;

import galena.oreganized.content.critera.DummyCriterionTrigger;
import galena.oreganized.content.item.ThermometerItem;
import galena.oreganized.data.provider.OLangProvider;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OCriteriaTriggers;
import galena.oreganized.index.OEffects;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OTags;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EffectsChangedTrigger;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class OAdvancements
extends AdvancementProvider {
    public OAdvancements(PackOutput output, CompletableFuture<HolderLookup.Provider> future, ExistingFileHelper helper, OLangProvider lang) {
        super(output, future, helper, List.of(new OreganizedAdvancements(lang)));
    }

    static class OreganizedAdvancements
    implements AdvancementProvider.AdvancementGenerator {
        private final OLangProvider lang;

        OreganizedAdvancements(OLangProvider lang) {
            this.lang = lang;
            lang.addSubProvider(() -> this.generate(null, $ -> {}, null));
        }

        public void generate(@Nullable HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer, @Nullable ExistingFileHelper helper) {
            Advancement.Builder.advancement().parent(this.getAdv("minecraft:adventure/root")).display(this.info((ItemLike)OItems.SILVER_MIRROR.get(), "mirror_mirror", AdvancementType.TASK, "Mirror, Mirror who is the fairest?", "Obtain a Silver Mirror")).addCriterion("has_silver_mirror", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)OItems.SILVER_MIRROR.get()})).save(consumer, "oreganized:adventure/mirror_mirror");
            AdvancementHolder likeTheRomans = Advancement.Builder.advancement().parent(this.getAdv("minecraft:story/upgrade_tools")).display(this.info((ItemLike)OItems.LEAD_INGOT.get(), "like_the_romans", AdvancementType.TASK, "Like the Romans", "Get Brain Damage from interacting with lead")).addCriterion("has_brain_damage", EffectsChangedTrigger.TriggerInstance.hasEffects((MobEffectsPredicate.Builder)MobEffectsPredicate.Builder.effects().and(OEffects.STUNNING))).save(consumer, "oreganized:story/like_the_romans");
            Advancement.Builder.advancement().parent(likeTheRomans).display(this.info((ItemLike)OItems.MOLTEN_LEAD_BUCKET.get(), "profound_brain_damage", AdvancementType.TASK, "Profound Brain Damage", "Let your health reach half a heart while having the Brain Damage effect")).addCriterion("stunned", ((DummyCriterionTrigger)((Object)OCriteriaTriggers.PROFOUND_BRAIN_DAMAGE.value())).createCriterion()).save(consumer, "oreganized:story/profound_brain_damage");
            AdvancementHolder obtainSilver = Advancement.Builder.advancement().parent(this.getAdv("minecraft:story/iron_tools")).display(this.info((ItemLike)OItems.SILVER_INGOT.get(), "obtain_silver", AdvancementType.TASK, "Every Stone has a Silver Lining", "Smelt Raw Silver")).addCriterion("has_silver_ingot", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(OTags.Items.INGOTS_SILVER).build()})).save(consumer, "oreganized:story/obtain_silver");
            Advancement.Builder.advancement().parent(obtainSilver).display(this.info((ItemLike)OItems.ELECTRUM_CHESTPLATE.get(), "electrum_gear", AdvancementType.CHALLENGE, "Cover me in... Wings?", "Obtain a full set of electrum armor")).addCriterion("has_all_electrum_armor", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)OItems.ELECTRUM_HELMET.get(), (ItemLike)OItems.ELECTRUM_CHESTPLATE.get(), (ItemLike)OItems.ELECTRUM_LEGGINGS.get(), (ItemLike)OItems.ELECTRUM_BOOTS.get()})).save(consumer, "oreganized:story/electrum_gear");
            Advancement.Builder.advancement().parent(obtainSilver).display(this.info((ItemLike)OItems.SPEEDOMETER.get(), "terminal_velocity", AdvancementType.TASK, "Got some fallin' To do", "Achieve Terminal Velocity by falling")).addCriterion("terminal_velocity", ((DummyCriterionTrigger)((Object)OCriteriaTriggers.TERMINAL_VELOCITY.value())).createCriterion()).save(consumer, "oreganized:adventure/terminal_velocity");
            AdvancementHolder meltingPoint = Advancement.Builder.advancement().parent(this.getAdv("minecraft:story/upgrade_tools")).display(this.info((ItemLike)OItems.MOLTEN_LEAD_BUCKET.get(), "melting_point", AdvancementType.TASK, "Melting Point", "Pick up Molten Lead from a cauldron")).addCriterion("has_molten_lead_bucket", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)OItems.MOLTEN_LEAD_BUCKET.get()})).save(consumer, "oreganized:story/melting_point");
            Advancement.Builder.advancement().parent(meltingPoint).display(this.info((ItemLike)OItems.MUSIC_DISC_STRUCTURE.get(), "disc_smith", AdvancementType.TASK, "Disc Smith", "Submerge a broken music disc into molten lead")).addCriterion("has_structure_disc", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)OItems.MUSIC_DISC_STRUCTURE.get()})).save(consumer, "oreganized:story/disc_smith");
            AdvancementHolder weepingDevil = Advancement.Builder.advancement().parent(this.getAdv("minecraft:adventure/root")).display(this.info((ItemLike)OBlocks.GARGOYLE.get(), "weeping_devil", AdvancementType.TASK, "Weeping Devil", "Exchange a Silver Ingot for a hellish growl of the Gargoyle")).addCriterion("activated_gargoyle", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{(Block)OBlocks.GARGOYLE.get()})), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(OTags.Items.INGOTS_SILVER))).save(consumer, "oreganized:adventure/weeping_devil");
            Advancement.Builder.advancement().parent(weepingDevil).display(this.info((ItemLike)Items.WATER_BUCKET, "garglin_water", AdvancementType.TASK, "Garglin' Water", "Provide Gargoyle with a source of water to spew even without rain")).addCriterion("see_gargoyle_gargle", ((DummyCriterionTrigger)((Object)OCriteriaTriggers.SEE_GARGOYLE_GARGLE.value())).createCriterion()).save(consumer, "oreganized:adventure/garglin_water");
            Advancement.Builder.advancement().parent(this.getAdv("adventure/whos_the_pillager_now")).display(this.info(new ItemStack((ItemLike)Items.CROSSBOW), "demoted", AdvancementType.CHALLENGE, "Demoted", "Use lead bolts in a crossbow to strip a pillager of his Ominous Banner")).addCriterion("see_gargoyle_gargle", ((DummyCriterionTrigger)((Object)OCriteriaTriggers.KNOCKED_BANNER_OFF.value())).createCriterion()).save(consumer, "oreganized:adventure/demoted");
            Advancement.Builder.advancement().parent(this.getAdv("husbandry/root")).display(this.info((ItemLike)OBlocks.GROOVED_ICE.get(), "groovy", AdvancementType.TASK, "Groovy", "Use the scribe to make grooves on Ice!")).addCriterion("use_scribe_on_ice", ItemUsedOnLocationTrigger.TriggerInstance.itemUsedOnBlock((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(BlockTags.ICE)), (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)OItems.SCRIBE.get()}))).save(consumer, "oreganized:husbandry/groovy");
            Advancement.Builder.advancement().parent(this.getAdv("story/root")).display(this.info((ItemLike)OBlocks.LEAD_ORE.get(), "lead_to_dust", AdvancementType.TASK, "Well... That leads to dust", "Mine lead ore without adjacent water to block the toxic dust cloud from forming")).addCriterion("in_lead_cloud", ((DummyCriterionTrigger)((Object)OCriteriaTriggers.IN_LEAD_CLOUD.value())).createCriterion()).save(consumer, "oreganized:story/lead_to_dust");
            Int2ObjectFunction thermometer = heat -> {
                ItemStack stack = new ItemStack((ItemLike)OItems.THERMOMETER.get());
                ThermometerItem.setHeatLevel(stack, null, heat);
                return stack;
            };
            AdvancementHolder shakeItOff = Advancement.Builder.advancement().parent(this.getAdv("husbandry/root")).display(this.info((ItemStack)thermometer.get(1), "shake_it_off", AdvancementType.TASK, "Shake it off!", "Shake the Thermometer and recalibrate its value")).addCriterion("shaken_thermometer", ((DummyCriterionTrigger)((Object)OCriteriaTriggers.SHAKEN_THERMOMETER.value())).createCriterion()).save(consumer, "oreganized:husbandry/shake_it_off");
            Advancement.Builder.advancement().parent(shakeItOff).display(this.info((ItemStack)thermometer.apply(7), "thermal_shock", AdvancementType.TASK, "Thermal Shock", "Cool your Thermometer too quickly in water, destroying it")).addCriterion("broken_thermometer", ((DummyCriterionTrigger)((Object)OCriteriaTriggers.BROKEN_THERMOMETER.value())).createCriterion()).save(consumer, "oreganized:husbandry/thermal_shock");
        }

        protected AdvancementHolder getAdv(String loc) {
            return Advancement.Builder.advancement().build(ResourceLocation.parse((String)loc));
        }

        protected DisplayInfo info(ItemLike icon, String id, AdvancementType type, String title, String description) {
            return this.info(new ItemStack(icon), id, type, title, description);
        }

        protected DisplayInfo info(ItemStack icon, String id, AdvancementType type, String title, String description) {
            String advancementId = "oreganized." + id;
            this.lang.addAdvTitle(advancementId, title);
            this.lang.addAdvDesc(advancementId, description);
            return new DisplayInfo(icon, (Component)Component.translatable((String)"advancements.%s.title".formatted(advancementId)), (Component)Component.translatable((String)"advancements.%s.description".formatted(advancementId)), Optional.empty(), type, true, true, false);
        }
    }
}

