/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data;

import galena.oreganized.index.DyeColors;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OTags;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class OBlockTags
extends IntrinsicHolderTagsProvider<Block> {
    public OBlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> future, @Nullable ExistingFileHelper helper) {
        super(output, Registries.BLOCK, future, block -> block.builtInRegistryHolder().key(), "oreganized", helper);
    }

    @NotNull
    public String getName() {
        return "Oreganized Block Tags";
    }

    private static TagKey<Block> dyedTag(DyeColor color) {
        return TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyed/" + color.getSerializedName())));
    }

    private void tagDyed(Map<DyeColor, ? extends Supplier<? extends Block>> values, TagKey<Block> ... keys) {
        values.entrySet().stream().sorted(Map.Entry.comparingByKey(DyeColors.comparator())).forEach(entry -> {
            Block block = (Block)((Supplier)entry.getValue()).get();
            ResourceLocation id = BuiltInRegistries.BLOCK.getKey((Object)block);
            for (TagKey key : keys) {
                this.tag(key).addOptional(id);
            }
            this.tag(Tags.Blocks.DYED).addOptional(id);
            this.tag(OBlockTags.dyedTag((DyeColor)entry.getKey())).addOptional(id);
        });
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tagDyed(OBlocks.CRYSTAL_GLASS, OTags.Blocks.CRYSTAL_GLASS);
        this.tagDyed(OBlocks.CRYSTAL_GLASS_PANES, OTags.Blocks.CRYSTAL_GLASS_PANES);
        this.tag(OTags.Blocks.FIRE_SOURCE).addTag(BlockTags.FIRE).addTag(BlockTags.CAMPFIRES);
        this.tag(OTags.Blocks.STONE_TYPES_GLANCE).add((Object[])new Block[]{(Block)OBlocks.POLISHED_GLANCE.get(), (Block)OBlocks.GLANCE_BRICKS.get(), (Block)OBlocks.CHISELED_GLANCE.get(), (Block)OBlocks.GLANCE_BRICK_STAIRS.get(), (Block)OBlocks.GLANCE_BRICK_WALL.get()});
        this.tag(OTags.Blocks.ORES_SILVER).add((Object[])new Block[]{(Block)OBlocks.SILVER_ORE.get(), (Block)OBlocks.DEEPSLATE_SILVER_ORE.get()});
        this.tag(OTags.Blocks.ORES_LEAD).add((Object[])new Block[]{(Block)OBlocks.LEAD_ORE.get(), (Block)OBlocks.DEEPSLATE_LEAD_ORE.get()});
        this.tag(OTags.Blocks.STORAGE_BLOCKS_SILVER).add((Object)((Block)OBlocks.SILVER_BLOCK.get()));
        this.tag(OTags.Blocks.STORAGE_BLOCKS_LEAD).add((Object)((Block)OBlocks.LEAD_BLOCK.get()));
        this.tag(OTags.Blocks.STORAGE_BLOCKS_ELECTRUM).add((Object)((Block)OBlocks.ELECTRUM_BLOCK.get()));
        this.tag(OTags.Blocks.STORAGE_BLOCKS_RAW_SILVER).add((Object)((Block)OBlocks.RAW_SILVER_BLOCK.get()));
        this.tag(OTags.Blocks.STORAGE_BLOCKS_RAW_LEAD).add((Object)((Block)OBlocks.RAW_LEAD_BLOCK.get()));
        this.tag(BlockTags.WALLS).add((Object[])new Block[]{(Block)OBlocks.GLANCE_WALL.get(), (Block)OBlocks.GLANCE_BRICK_WALL.get()});
        this.tag(BlockTags.STAIRS).add((Object[])new Block[]{(Block)OBlocks.GLANCE_STAIRS.get(), (Block)OBlocks.POLISHED_GLANCE_STAIRS.get(), (Block)OBlocks.GLANCE_BRICK_STAIRS.get()});
        this.tag(BlockTags.SLABS).add((Object[])new Block[]{(Block)OBlocks.GLANCE_SLAB.get(), (Block)OBlocks.POLISHED_GLANCE_SLAB.get(), (Block)OBlocks.GLANCE_BRICK_SLAB.get()});
        this.tag(BlockTags.BEACON_BASE_BLOCKS).addTag(OTags.Blocks.STORAGE_BLOCKS_SILVER).addTag(OTags.Blocks.STORAGE_BLOCKS_ELECTRUM);
        this.tag(BlockTags.IMPERMEABLE).addTag(OTags.Blocks.CRYSTAL_GLASS);
        this.tag(BlockTags.CAULDRONS).add((Object)((Block)OBlocks.MOLTEN_LEAD_CAULDRON.get()));
        this.tag(BlockTags.DOORS).add((Object)((Block)OBlocks.LEAD_DOOR.get()));
        this.tag(BlockTags.TRAPDOORS).add((Object)((Block)OBlocks.LEAD_TRAPDOOR.get()));
        this.tag(BlockTags.SMALL_FLOWERS).add((Object)((Block)OBlocks.WHITE_DATURA.get()));
        this.tag(BlockTags.SMALL_FLOWERS).add((Object)((Block)OBlocks.PURPLE_DATURA.get()));
        this.tag(Tags.Blocks.ORES).addTags(new TagKey[]{OTags.Blocks.ORES_SILVER, OTags.Blocks.ORES_LEAD});
        this.tag(Tags.Blocks.ORE_RATES_SINGULAR).addTags(new TagKey[]{OTags.Blocks.ORES_SILVER, OTags.Blocks.ORES_LEAD});
        this.tag(Tags.Blocks.STORAGE_BLOCKS).addTags(new TagKey[]{OTags.Blocks.STORAGE_BLOCKS_SILVER, OTags.Blocks.STORAGE_BLOCKS_LEAD, OTags.Blocks.STORAGE_BLOCKS_ELECTRUM, OTags.Blocks.STORAGE_BLOCKS_RAW_SILVER, OTags.Blocks.STORAGE_BLOCKS_RAW_LEAD}).add((Object)((Block)OBlocks.LEAD_BOLT_CRATE.get()));
        this.tag(Tags.Blocks.GLASS_BLOCKS).addTag(OTags.Blocks.CRYSTAL_GLASS);
        this.tag(Tags.Blocks.GLASS_PANES).addTag(OTags.Blocks.CRYSTAL_GLASS_PANES);
        this.tag(Tags.Blocks.ORES_IN_GROUND_STONE).add((Object[])new Block[]{(Block)OBlocks.LEAD_ORE.get(), (Block)OBlocks.SILVER_ORE.get()});
        this.tag(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE).add((Object[])new Block[]{(Block)OBlocks.DEEPSLATE_LEAD_ORE.get(), (Block)OBlocks.DEEPSLATE_SILVER_ORE.get()});
        Stream.of(OBlocks.LEAD_ORE, OBlocks.DEEPSLATE_LEAD_ORE, OBlocks.RAW_LEAD_BLOCK, OBlocks.LEAD_BLOCK, OBlocks.LEAD_BRICKS, OBlocks.LEAD_PILLAR, OBlocks.LEAD_BULB, OBlocks.CUT_LEAD, OBlocks.ELECTRUM_BLOCK, OBlocks.LEAD_DOOR, OBlocks.LEAD_TRAPDOOR, OBlocks.LEAD_BARS).map(DeferredHolder::get).forEach(block -> {
            this.tag(BlockTags.NEEDS_STONE_TOOL).add(block);
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add(block);
        });
        this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add((Object[])new Block[]{(Block)OBlocks.SILVER_ORE.get(), (Block)OBlocks.DEEPSLATE_SILVER_ORE.get(), (Block)OBlocks.RAW_SILVER_BLOCK.get(), (Block)OBlocks.SILVER_BLOCK.get(), (Block)OBlocks.GLANCE.get(), (Block)OBlocks.GLANCE_STAIRS.get(), (Block)OBlocks.GLANCE_SLAB.get(), (Block)OBlocks.POLISHED_GLANCE.get(), (Block)OBlocks.POLISHED_GLANCE_STAIRS.get(), (Block)OBlocks.POLISHED_GLANCE_SLAB.get(), (Block)OBlocks.GLANCE_WALL.get(), (Block)OBlocks.GLANCE_BRICKS.get(), (Block)OBlocks.GLANCE_BRICK_STAIRS.get(), (Block)OBlocks.GLANCE_BRICK_SLAB.get(), (Block)OBlocks.GLANCE_BRICK_WALL.get(), (Block)OBlocks.CHISELED_GLANCE.get(), (Block)OBlocks.SPOTTED_GLANCE.get(), (Block)OBlocks.WAXED_SPOTTED_GLANCE.get(), (Block)OBlocks.GARGOYLE.get(), (Block)OBlocks.MOLTEN_LEAD_CAULDRON.get(), (Block)OBlocks.GROOVED_ICE.get(), (Block)OBlocks.GROOVED_PACKED_ICE.get(), (Block)OBlocks.GROOVED_BLUE_ICE.get()});
        this.tagDyed(OBlocks.WAXED_CONCRETE_POWDER, BlockTags.MINEABLE_WITH_SHOVEL);
        this.tag(BlockTags.NEEDS_IRON_TOOL).add((Object[])new Block[]{(Block)OBlocks.SILVER_ORE.get(), (Block)OBlocks.DEEPSLATE_SILVER_ORE.get(), (Block)OBlocks.SILVER_BLOCK.get(), (Block)OBlocks.RAW_SILVER_BLOCK.get()});
        this.tag(BlockTags.MINEABLE_WITH_AXE).add((Object)((Block)OBlocks.LEAD_BOLT_CRATE.get()));
        this.tag(OTags.Blocks.MELTS_LEAD).add((Object)Blocks.LAVA).add((Object)Blocks.MAGMA_BLOCK).addTags(new TagKey[]{BlockTags.CAMPFIRES}).addTags(new TagKey[]{BlockTags.FIRE});
        this.tag(BlockTags.ICE).add((Object)((Block)OBlocks.GROOVED_ICE.get())).add((Object)((Block)OBlocks.GROOVED_PACKED_ICE.get())).add((Object)((Block)OBlocks.GROOVED_BLUE_ICE.get()));
        this.tag(OTags.Blocks.AMETHYST_CLUSTERS).add((Object)Blocks.AMETHYST_CLUSTER).add((Object)Blocks.LARGE_AMETHYST_BUD).add((Object)Blocks.MEDIUM_AMETHYST_BUD).add((Object)Blocks.SMALL_AMETHYST_BUD);
        this.tag(OTags.Blocks.QUARTZITE_CLUSTERS).addOptional(ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)"quartzite_cluster")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)"large_quartzite_bud")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)"medium_quartzite_bud")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)"small_quartzite_bud"));
        IntrinsicHolderTagsProvider.IntrinsicTagAppender scribeMineable = this.tag(OTags.Blocks.MINEABLE_WITH_SCRIBE).addTags(new TagKey[]{Tags.Blocks.GLASS_BLOCKS}).addTags(new TagKey[]{Tags.Blocks.GLASS_PANES}).addTags(new TagKey[]{Tags.Blocks.OBSIDIANS}).addTags(new TagKey[]{OTags.Blocks.AMETHYST_CLUSTERS}).addTags(new TagKey[]{OTags.Blocks.QUARTZITE_CLUSTERS}).addTags(new TagKey[]{BlockTags.ICE}).addTags(new TagKey[]{BlockTags.CRYSTAL_SOUND_BLOCKS}).add((Object)Blocks.AMETHYST_BLOCK);
        scribeMineable.add((Object)Blocks.QUARTZ_BRICKS).add((Object)Blocks.QUARTZ_PILLAR).add((Object)Blocks.QUARTZ_SLAB).add((Object)Blocks.QUARTZ_STAIRS).add((Object)Blocks.CHISELED_QUARTZ_BLOCK).add((Object)Blocks.SMOOTH_QUARTZ).add((Object)Blocks.SMOOTH_QUARTZ_SLAB).add((Object)Blocks.SMOOTH_QUARTZ_STAIRS);
        scribeMineable.addOptionalTag(ResourceLocation.fromNamespaceAndPath((String)"botania", (String)"quartz_blocks"));
        Stream.of("%s", "waxed_%s", "%s_cluster", "%s_pane").forEach(pattern -> scribeMineable.addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)pattern.formatted("red_corundum"))).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)pattern.formatted("orange_corundum"))).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)pattern.formatted("yellow_corundum"))).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)pattern.formatted("green_corundum"))).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)pattern.formatted("blue_corundum"))).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)pattern.formatted("indigo_corundum"))).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)pattern.formatted("violet_corundum"))).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)pattern.formatted("white_corundum"))).addOptional(ResourceLocation.fromNamespaceAndPath((String)"quark", (String)pattern.formatted("black_corundum"))));
        scribeMineable.addOptional(ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"quartz_cluster")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"flawless_budding_quartz")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"flawed_budding_quartz")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"damaged_budding_quartz")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"chipped_budding_quartz"));
        this.tag(OTags.Blocks.SILKTOUCH_WITH_SCRIBE_BLACKLIST).add((Object)((Block)OBlocks.GROOVED_ICE.get())).add((Object)((Block)OBlocks.GROOVED_PACKED_ICE.get())).add((Object)((Block)OBlocks.GROOVED_BLUE_ICE.get()));
        this.tag(BlockTags.SNOW_LAYER_CANNOT_SURVIVE_ON).add((Object)((Block)OBlocks.GROOVED_ICE.get())).add((Object)((Block)OBlocks.GROOVED_PACKED_ICE.get()));
        this.tag(OTags.Blocks.SILKTOUCH_WITH_SCRIBE).addTags(new TagKey[]{OTags.Blocks.MINEABLE_WITH_SCRIBE}).addTags(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE});
        this.tag(OTags.Blocks.PREVENTS_LEAD_CLOUD).add((Object)Blocks.WATER).addOptional(ResourceLocation.fromNamespaceAndPath((String)"spelunkery", (String)"spring_water"));
        this.tag(OTags.Blocks.CREATES_LEAD_CLOUD).addTags(new TagKey[]{OTags.Blocks.ORES_LEAD}).addTags(new TagKey[]{OTags.Blocks.STORAGE_BLOCKS_RAW_LEAD});
        this.tag(OTags.Blocks.BLOWS_LEAD_CLOUD).addTags(new TagKey[]{OTags.Blocks.CREATES_LEAD_CLOUD});
        this.tag(OTags.Blocks.FIRE_HEAT_LEVEL).addTags(new TagKey[]{BlockTags.FIRE}).addTags(new TagKey[]{BlockTags.CAMPFIRES});
        this.tag(OTags.Blocks.LAVA_HEAT_LEVEL).add((Object)Blocks.MAGMA_BLOCK).add((Object)Blocks.LAVA).add((Object)((Block)OBlocks.MOLTEN_LEAD.get())).add((Object)Blocks.LAVA_CAULDRON).add((Object)((Block)OBlocks.MOLTEN_LEAD_CAULDRON.get()));
        this.tag(OTags.Blocks.CARRY_ON_BLACKLIST).add((Object)((Block)OBlocks.LEAD_DOOR.get())).add((Object)((Block)OBlocks.LEAD_TRAPDOOR.get()));
        this.tag(OTags.Blocks.BOMB_BREAKABLE).add((Object)((Block)OBlocks.SHRAPNEL_BOMB.get()));
        this.tag(OTags.Blocks.CANNON_TNTS).add((Object)((Block)OBlocks.SHRAPNEL_BOMB.get()));
    }
}

