/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data;

import galena.oreganized.content.block.LeadDoorBlock;
import galena.oreganized.content.block.LeadTrapdoorBlock;
import galena.oreganized.index.DyeColors;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OTags;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class OItemTags
extends ItemTagsProvider {
    public OItemTags(PackOutput output, CompletableFuture<HolderLookup.Provider> future, CompletableFuture<TagsProvider.TagLookup<Block>> provider, @Nullable ExistingFileHelper helper) {
        super(output, future, provider, "oreganized", helper);
    }

    public String getName() {
        return "Oreganized Item Tags";
    }

    private static TagKey<Item> dyedTag(DyeColor color) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)("dyed/" + color.getSerializedName())));
    }

    private void tagDyed(Map<DyeColor, ? extends Supplier<? extends ItemLike>> values, TagKey<Item> ... keys) {
        values.entrySet().stream().sorted(Map.Entry.comparingByKey(DyeColors.comparator())).forEach(entry -> {
            Item item = ((ItemLike)((Supplier)entry.getValue()).get()).asItem();
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
            for (TagKey key : keys) {
                this.tag(key).addOptional(id);
            }
            this.tag(Tags.Items.DYED).addOptional(id);
            this.tag(OItemTags.dyedTag((DyeColor)entry.getKey())).addOptional(id);
        });
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tagDyed(OBlocks.CRYSTAL_GLASS, OTags.Items.CRYSTAL_GLASS);
        this.tagDyed(OBlocks.CRYSTAL_GLASS_PANES, OTags.Items.CRYSTAL_GLASS_PANES);
        this.tag(OTags.Items.LIGHTER_THAN_LEAD).add((Object)Items.IRON_BOOTS);
        this.copy(OTags.Blocks.STONE_TYPES_GLANCE, OTags.Items.STONE_TYPES_GLANCE);
        this.tag(OTags.Items.RAW_MATERIALS_SILVER).add((Object)((Item)OItems.RAW_SILVER.get()));
        this.tag(OTags.Items.RAW_MATERIALS_LEAD).add((Object)((Item)OItems.RAW_LEAD.get()));
        this.tag(OTags.Items.INGOTS_SILVER).add((Object)((Item)OItems.SILVER_INGOT.get()));
        this.tag(OTags.Items.INGOTS_LEAD).add((Object)((Item)OItems.LEAD_INGOT.get()));
        this.tag(OTags.Items.INGOTS_ELECTRUM).add((Object)((Item)OItems.ELECTRUM_INGOT.get()));
        this.tag(OTags.Items.NUGGETS_SILVER).add((Object)((Item)OItems.SILVER_NUGGET.get()));
        this.tag(OTags.Items.NUGGETS_LEAD).add((Object)((Item)OItems.LEAD_NUGGET.get()));
        this.tag(OTags.Items.NUGGETS_ELECTRUM).add((Object)((Item)OItems.ELECTRUM_NUGGET.get()));
        this.tag(OTags.Items.NUGGETS_NETHERITE).add((Object)((Item)OItems.NETHERITE_NUGGET.get()));
        this.tag(OTags.Items.BUCKETS_MOLTEN_LEAD).add((Object)((Item)OItems.MOLTEN_LEAD_BUCKET.get()));
        this.tag(Tags.Items.BUCKETS).addTags(new TagKey[]{OTags.Items.BUCKETS_MOLTEN_LEAD});
        this.tag(OTags.Items.TOOLS_BUSH_HAMMER).add((Object)((Item)OItems.BUSH_HAMMER.get()));
        this.tag(Tags.Items.TOOLS).add((Object)((Item)OItems.FLINT_AND_PEWTER.get()));
        this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object)((Item)OItems.FLINT_AND_PEWTER.get()));
        this.tag(ItemTags.VANISHING_ENCHANTABLE).add((Object)((Item)OItems.FLINT_AND_PEWTER.get()));
        this.tag(ItemTags.PIGLIN_LOVED).add((Object)((Item)OItems.SILVER_MIRROR.get()));
        this.tag(Tags.Items.MUSIC_DISCS).add((Object)((Item)OItems.MUSIC_DISC_STRUCTURE.get()));
        this.copy(OTags.Blocks.ORES_SILVER, OTags.Items.ORES_SILVER);
        this.copy(OTags.Blocks.ORES_LEAD, OTags.Items.ORES_LEAD);
        this.copy(OTags.Blocks.STORAGE_BLOCKS_SILVER, OTags.Items.STORAGE_BLOCKS_SILVER);
        this.copy(OTags.Blocks.STORAGE_BLOCKS_LEAD, OTags.Items.STORAGE_BLOCKS_LEAD);
        this.copy(OTags.Blocks.STORAGE_BLOCKS_ELECTRUM, OTags.Items.STORAGE_BLOCKS_ELECTRUM);
        this.copy(OTags.Blocks.STORAGE_BLOCKS_RAW_SILVER, OTags.Items.STORAGE_BLOCKS_RAW_SILVER);
        this.copy(OTags.Blocks.STORAGE_BLOCKS_RAW_LEAD, OTags.Items.STORAGE_BLOCKS_RAW_LEAD);
        this.copy(BlockTags.WALLS, ItemTags.WALLS);
        this.copy(BlockTags.STAIRS, ItemTags.STAIRS);
        this.copy(BlockTags.SLABS, ItemTags.SLABS);
        this.tag(ItemTags.BEACON_PAYMENT_ITEMS).add((Object)((Item)OItems.SILVER_INGOT.get())).add((Object)((Item)OItems.ELECTRUM_INGOT.get()));
        this.tag(ItemTags.HEAD_ARMOR).add((Object)((Item)OItems.ELECTRUM_HELMET.get()));
        this.tag(ItemTags.CHEST_ARMOR).add((Object)((Item)OItems.ELECTRUM_CHESTPLATE.get()));
        this.tag(ItemTags.LEG_ARMOR).add((Object)((Item)OItems.ELECTRUM_LEGGINGS.get()));
        this.tag(ItemTags.FOOT_ARMOR).add((Object)((Item)OItems.ELECTRUM_BOOTS.get()));
        this.tag(ItemTags.TRIM_MATERIALS).add((Object[])new Item[]{(Item)OItems.LEAD_INGOT.get(), (Item)OItems.SILVER_INGOT.get(), (Item)OItems.ELECTRUM_INGOT.get()});
        this.tag(ItemTags.SMALL_FLOWERS).add((Object)((Block)OBlocks.WHITE_DATURA.get()).asItem());
        this.tag(ItemTags.SMALL_FLOWERS).add((Object)((Block)OBlocks.PURPLE_DATURA.get()).asItem());
        this.tag(Tags.Items.NUGGETS).addTags(new TagKey[]{OTags.Items.NUGGETS_SILVER, OTags.Items.NUGGETS_LEAD, OTags.Items.NUGGETS_ELECTRUM, OTags.Items.NUGGETS_NETHERITE});
        this.tag(Tags.Items.INGOTS).addTags(new TagKey[]{OTags.Items.INGOTS_SILVER, OTags.Items.INGOTS_LEAD, OTags.Items.INGOTS_ELECTRUM});
        this.tag(Tags.Items.ORES).addTags(new TagKey[]{OTags.Items.ORES_SILVER, OTags.Items.ORES_LEAD});
        this.tag(Tags.Items.STORAGE_BLOCKS).addTags(new TagKey[]{OTags.Items.STORAGE_BLOCKS_SILVER, OTags.Items.STORAGE_BLOCKS_LEAD, OTags.Items.STORAGE_BLOCKS_ELECTRUM, OTags.Items.STORAGE_BLOCKS_RAW_SILVER, OTags.Items.STORAGE_BLOCKS_RAW_LEAD}).add((Object)OBlocks.LEAD_BOLT_CRATE.asItem());
        this.tag(Tags.Items.GLASS_BLOCKS).addTags(new TagKey[]{OTags.Items.CRYSTAL_GLASS});
        this.tag(Tags.Items.GLASS_PANES).addTags(new TagKey[]{OTags.Items.CRYSTAL_GLASS_PANES});
        this.tag(Tags.Items.RAW_MATERIALS).addTags(new TagKey[]{OTags.Items.RAW_MATERIALS_SILVER, OTags.Items.RAW_MATERIALS_LEAD});
        this.copy(Tags.Blocks.ORES_IN_GROUND_STONE, Tags.Items.ORES_IN_GROUND_STONE);
        this.copy(Tags.Blocks.ORES_IN_GROUND_DEEPSLATE, Tags.Items.ORES_IN_GROUND_DEEPSLATE);
        this.tag(ItemTags.DOORS).add((Object)((LeadDoorBlock)OBlocks.LEAD_DOOR.get()).asItem());
        this.tag(ItemTags.TRAPDOORS).add((Object)((LeadTrapdoorBlock)OBlocks.LEAD_TRAPDOOR.get()).asItem());
        this.tag(ItemTags.AXES).add((Object)((Item)OItems.ELECTRUM_AXE.get()));
        this.tag(ItemTags.PICKAXES).add((Object)((Item)OItems.ELECTRUM_PICKAXE.get()));
        this.tag(ItemTags.SWORDS).add((Object)((Item)OItems.ELECTRUM_SWORD.get()));
        this.tag(ItemTags.SHOVELS).add((Object)((Item)OItems.ELECTRUM_SHOVEL.get()));
        this.tag(ItemTags.HOES).add((Object)((Item)OItems.ELECTRUM_HOE.get()));
        this.tag(OTags.Items.TOOLS_KNIVES).add((Object)((Item)OItems.ELECTRUM_KNIFE.get()));
        this.tag(OTags.Items.SHIELDS).add((Object)((Item)OItems.ELECTRUM_SHIELD.get()));
        this.tag(OTags.Items.SHIELDS_SE).add((Object)((Item)OItems.ELECTRUM_SHIELD.get()));
        this.tag(OTags.Items.MACHETES).add((Object)((Item)OItems.ELECTRUM_MACHETE.get()));
        this.tag(OTags.Items.HAS_KINETIC_DAMAGE).add((Object[])new Item[]{(Item)OItems.ELECTRUM_AXE.get(), (Item)OItems.ELECTRUM_HOE.get(), (Item)OItems.ELECTRUM_KNIFE.get(), (Item)OItems.ELECTRUM_MACHETE.get(), (Item)OItems.ELECTRUM_PICKAXE.get(), (Item)OItems.ELECTRUM_SHOVEL.get(), (Item)OItems.ELECTRUM_SWORD.get()});
        this.tag(Tags.Items.MELEE_WEAPON_TOOLS).add((Object)((Item)OItems.ELECTRUM_AXE.get())).add((Object)((Item)OItems.ELECTRUM_SWORD.get())).add((Object)((Item)OItems.ELECTRUM_MACHETE.get()));
        this.tag(OTags.Items.GARGOYLE_SNACK).addTags(new TagKey[]{OTags.Items.INGOTS_SILVER});
        IntrinsicHolderTagsProvider.IntrinsicTagAppender protectiveArmorParts = this.tag(OTags.Items.PROTECTIVE_ARMOR_PART);
        IntrinsicHolderTagsProvider.IntrinsicTagAppender protectiveHelmets = this.tag(OTags.Items.PROTECTIVE_HELMET);
        protectiveArmorParts.addOptional(ResourceLocation.fromNamespaceAndPath((String)"thermal", (String)"hazmat_helmet")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"thermal", (String)"hazmat_chestplate")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"thermal", (String)"hazmat_leggings")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"thermal", (String)"hazmat_boots"));
        protectiveArmorParts.addOptional(ResourceLocation.fromNamespaceAndPath((String)"alexscaves", (String)"hazmat_mask")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"alexscaves", (String)"hazmat_chestplate")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"alexscaves", (String)"hazmat_leggings")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"alexscaves", (String)"hazmat_boots"));
        protectiveHelmets.addOptional(ResourceLocation.fromNamespaceAndPath((String)"createbigcannons", (String)"gas_mask"));
        protectiveHelmets.addOptional(ResourceLocation.fromNamespaceAndPath((String)"scguns", (String)"anthralite_respirator")).addOptional(ResourceLocation.fromNamespaceAndPath((String)"scguns", (String)"netherite_respirator"));
        this.tagDyed(OBlocks.WAXED_CONCRETE_POWDER, new TagKey[0]);
    }
}

