/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data;

import galena.oreganized.Oreganized;
import galena.oreganized.content.block.IMeltableBlock;
import galena.oreganized.content.block.SpottedGlanceBlock;
import galena.oreganized.content.item.ThermometerItem;
import galena.oreganized.data.provider.OBlockLootProvider;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OEntityTypes;
import galena.oreganized.index.OItems;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class OLootTables
extends LootTableProvider {
    public OLootTables(PackOutput output, CompletableFuture<HolderLookup.Provider> lookup) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLoot::new, LootContextParamSets.BLOCK), new LootTableProvider.SubProviderEntry(EntityLoot::new, LootContextParamSets.ENTITY), new LootTableProvider.SubProviderEntry($ -> new OGameplayLoot(), LootContextParamSets.GIFT)), lookup);
    }

    public static class OGameplayLoot
    implements LootTableSubProvider {
        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(ThermometerItem.BREAK_LOOT_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)OItems.LEAD_NUGGET.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f)))));
            consumer.accept(SpottedGlanceBlock.WASH_LOOT_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)OItems.LEAD_NUGGET.get()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))));
        }
    }

    public static class EntityLoot
    extends EntityLootSubProvider {
        public EntityLoot(HolderLookup.Provider lookup) {
            super(FeatureFlags.REGISTRY.allFlags(), lookup);
        }

        public void generate() {
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return OEntityTypes.ENTITIES.getEntries().stream().map(Supplier::get);
        }
    }

    public static class BlockLoot
    extends OBlockLootProvider {
        protected BlockLoot(HolderLookup.Provider lookup) {
            super(lookup);
        }

        protected void generate() {
            this.cauldron((Supplier<? extends Block>)OBlocks.MOLTEN_LEAD_CAULDRON);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE);
            this.dropSelf((Supplier<? extends Block>)OBlocks.POLISHED_GLANCE);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE_BRICKS);
            this.dropSelf((Supplier<? extends Block>)OBlocks.CHISELED_GLANCE);
            this.slab((Supplier<? extends Block>)OBlocks.GLANCE_SLAB);
            this.slab((Supplier<? extends Block>)OBlocks.POLISHED_GLANCE_SLAB);
            this.slab((Supplier<? extends Block>)OBlocks.GLANCE_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)OBlocks.POLISHED_GLANCE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE_WALL);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GLANCE_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)OBlocks.SPOTTED_GLANCE);
            this.dropSelf((Supplier<? extends Block>)OBlocks.WAXED_SPOTTED_GLANCE);
            this.ore((Supplier<? extends Block>)OBlocks.SILVER_ORE, (Supplier<? extends Item>)OItems.RAW_SILVER);
            this.ore((Supplier<? extends Block>)OBlocks.DEEPSLATE_SILVER_ORE, (Supplier<? extends Item>)OItems.RAW_SILVER);
            this.ore((Supplier<? extends Block>)OBlocks.LEAD_ORE, (Supplier<? extends Item>)OItems.RAW_LEAD);
            this.ore((Supplier<? extends Block>)OBlocks.DEEPSLATE_LEAD_ORE, (Supplier<? extends Item>)OItems.RAW_LEAD);
            this.dropSelf((Supplier<? extends Block>)OBlocks.RAW_SILVER_BLOCK);
            this.dropSelf((Supplier<? extends Block>)OBlocks.RAW_LEAD_BLOCK);
            this.dropSelf((Supplier<? extends Block>)OBlocks.SILVER_BLOCK);
            this.dropSelf((Supplier<? extends Block>)OBlocks.WHITE_DATURA);
            this.dropSelf((Supplier<? extends Block>)OBlocks.PURPLE_DATURA);
            this.dropSelf((Supplier<? extends Block>)OBlocks.LEAD_BLOCK);
            this.dropSelf((Supplier<? extends Block>)OBlocks.LEAD_BRICKS);
            this.dropSelf((Supplier<? extends Block>)OBlocks.LEAD_PILLAR);
            this.dropSelf((Supplier<? extends Block>)OBlocks.LEAD_BULB);
            this.dropSelf((Supplier<? extends Block>)OBlocks.CUT_LEAD);
            this.dropSelf((Supplier<? extends Block>)OBlocks.ELECTRUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)OBlocks.GARGOYLE);
            this.dropSelf((Supplier<? extends Block>)OBlocks.SHRAPNEL_BOMB);
            this.dropSelf((Supplier<? extends Block>)OBlocks.LEAD_BOLT_CRATE);
            this.pottedPlant((Supplier<? extends FlowerPotBlock>)OBlocks.POTTED_PURPLE_DATURA);
            this.pottedPlant((Supplier<? extends FlowerPotBlock>)OBlocks.POTTED_WHITE_DATURA);
            this.grooved((Supplier<Block>)OBlocks.GROOVED_ICE, Blocks.ICE);
            this.grooved((Supplier<Block>)OBlocks.GROOVED_BLUE_ICE, Blocks.BLUE_ICE);
            this.grooved((Supplier<Block>)OBlocks.GROOVED_PACKED_ICE, Blocks.PACKED_ICE);
            this.add((Block)OBlocks.LEAD_DOOR.get(), LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)OBlocks.LEAD_DOOR.get(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)OBlocks.LEAD_DOOR.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)OBlocks.LEAD_DOOR.get()))))));
            this.dropSelf((Supplier<? extends Block>)OBlocks.LEAD_TRAPDOOR);
            this.add((Block)OBlocks.LEAD_BARS.get(), LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)OBlocks.LEAD_BARS.get(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)((ItemLike)OBlocks.LEAD_BARS.get())).when(this.hasSilkTouch()), LootItem.lootTableItem((ItemLike)((ItemLike)OItems.LEAD_NUGGET.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)3.0f))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)OBlocks.LEAD_BARS.get())).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)IMeltableBlock.GOOPYNESS_3, 2))), LootItem.lootTableItem((ItemLike)((ItemLike)OBlocks.LEAD_BARS.get()))})))));
            OBlocks.CRYSTAL_GLASS.forEach((c, b) -> this.dyed((DyeColor)c, () -> this.dropAsSilk((Supplier<? extends Block>)b)));
            OBlocks.CRYSTAL_GLASS_PANES.forEach((c, b) -> this.dyed((DyeColor)c, () -> this.dropAsSilk((Supplier<? extends Block>)b)));
            OBlocks.WAXED_CONCRETE_POWDER.forEach((c, b) -> this.dyed((DyeColor)c, () -> this.dropSelf((Supplier<? extends Block>)b)));
        }

        private void pottedPlant(Supplier<? extends FlowerPotBlock> block) {
            this.dropPottedContents((Block)block.get());
        }

        private void grooved(Supplier<Block> block, Block other) {
            LootItemCondition.Builder hasScribe = MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)OItems.SCRIBE.get()}));
            this.add(block.get(), LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)AlternativesEntry.alternatives((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.lootTableItem((ItemLike)block.get().asItem()).when(this.hasSilkTouch()), LootItem.lootTableItem((ItemLike)other.asItem()).when(hasScribe)}))));
        }

        protected Iterable<Block> getKnownBlocks() {
            return Oreganized.REGISTRY_HELPER.getBlockSubHelper().getDeferredRegister().getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

