/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.data.provider;

import com.teamabnormals.blueprint.core.data.client.BlueprintItemModelProvider;
import java.util.function.Supplier;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public abstract class OItemModelProvider
extends BlueprintItemModelProvider {
    public OItemModelProvider(PackOutput output, ExistingFileHelper help) {
        super(output, "oreganized", help);
    }

    protected String blockName(Supplier<? extends Block> block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block.get()).getPath();
    }

    private ResourceLocation blockTexture(Supplier<? extends Block> block) {
        return OItemModelProvider.key((ItemLike)((ItemLike)block.get())).withPrefix("block/");
    }

    public ItemModelBuilder block(Supplier<? extends Block> block) {
        return this.block(block, this.blockName(block));
    }

    public ItemModelBuilder block(Supplier<? extends Block> block, String name) {
        return (ItemModelBuilder)this.withExistingParent(this.blockName(block), this.modLoc("block/" + name));
    }

    public ItemModelBuilder blockFlat(Supplier<? extends Block> block) {
        return this.blockFlat(block, this.blockName(block));
    }

    public ItemModelBuilder blockFlat(Supplier<? extends Block> block, Supplier<? extends Block> fullBlock) {
        return this.blockFlat(block, this.blockName(fullBlock));
    }

    public ItemModelBuilder generated(String name, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/generated"))).texture("layer0", texture);
    }

    public ItemModelBuilder generated(Supplier<? extends ItemLike> itemLike, ResourceLocation texture) {
        return this.generated(OItemModelProvider.name((ItemLike)itemLike.get()), texture);
    }

    public ItemModelBuilder blockFlat(Supplier<? extends Block> block, String name) {
        return this.generated(block, this.modLoc("block/" + name));
    }

    public ItemModelBuilder normalItem(Supplier<? extends Item> item) {
        return this.generated(item, OItemModelProvider.itemTexture((ItemLike)((ItemLike)item.get())));
    }

    public ItemModelBuilder toolItem(Supplier<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath(), this.mcLoc("item/handheld"))).texture("layer0", OItemModelProvider.itemTexture((ItemLike)((ItemLike)item.get())));
    }

    public ItemModelBuilder shieldItem(Supplier<? extends Item> item) {
        ResourceLocation texture = OItemModelProvider.itemTexture((ItemLike)((ItemLike)item.get()));
        String name = OItemModelProvider.name((ItemLike)((ItemLike)item.get()));
        ItemModelBuilder blockingModel = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name + "_blocking", ResourceLocation.fromNamespaceAndPath((String)"shieldexp", (String)"item/netherite_shield_blocking"))).guiLight(BlockModel.GuiLight.FRONT)).texture("1", texture)).texture("particle", texture);
        return ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, ResourceLocation.fromNamespaceAndPath((String)"shieldexp", (String)"item/netherite_shield"))).guiLight(BlockModel.GuiLight.FRONT)).texture("1", texture)).texture("particle", texture)).override().predicate(ResourceLocation.withDefaultNamespace((String)"blocking"), 1.0f).model((ModelFile)blockingModel).end();
    }

    public ItemModelBuilder crossbowOverwrite(String name) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, "item/crossbow")).texture("layer0", this.modLoc("item/" + name));
    }

    public ItemModelBuilder wall(Supplier<? extends WallBlock> wall, Supplier<? extends Block> fullBlock) {
        return (ItemModelBuilder)this.wallInventory(BuiltInRegistries.BLOCK.getKey((Object)((Block)wall.get())).getPath(), this.blockTexture(fullBlock));
    }

    public ItemModelBuilder leveledDevice(Holder<? extends Item> item, int levels, ResourceLocation property) {
        ItemModelBuilder model = (ItemModelBuilder)this.withExistingParent(OItemModelProvider.name((ItemLike)((ItemLike)item.value())), "item/generated");
        for (int i = 0; i < levels; ++i) {
            ResourceLocation subName = OItemModelProvider.key((ItemLike)((ItemLike)item.value())).withSuffix("_" + i);
            ItemModelBuilder subModel = this.generated(subName.getPath(), subName.withPrefix("item/"));
            model.override().model((ModelFile)subModel).predicate(property, (float)i).end();
        }
        return model;
    }
}

