/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.index;

import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import galena.oreganized.Oreganized;
import galena.oreganized.content.block.BulbBlock;
import galena.oreganized.content.block.CrystalGlassBlock;
import galena.oreganized.content.block.CrystalGlassPaneBlock;
import galena.oreganized.content.block.GargoyleBlock;
import galena.oreganized.content.block.IMeltableBlock;
import galena.oreganized.content.block.LeadBarsBlock;
import galena.oreganized.content.block.LeadDoorBlock;
import galena.oreganized.content.block.LeadTrapdoorBlock;
import galena.oreganized.content.block.MeltableBlock;
import galena.oreganized.content.block.MeltablePillarBlock;
import galena.oreganized.content.block.MoltenLeadBlock;
import galena.oreganized.content.block.MoltenLeadCauldronBlock;
import galena.oreganized.content.block.ShrapnelBombBlock;
import galena.oreganized.content.block.SpottedGlanceBlock;
import galena.oreganized.index.DyeColors;
import galena.oreganized.index.OEffects;
import galena.oreganized.index.OFluids;
import galena.oreganized.index.OItems;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DoubleHighBlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredBlock;

public class OBlocks {
    public static final BlockSubRegistryHelper HELPER = (BlockSubRegistryHelper)Oreganized.REGISTRY_HELPER.getBlockSubHelper();
    private static final MapColor[] LEAD_MAP_COLORS = new MapColor[]{MapColor.TERRACOTTA_LIGHT_BLUE, MapColor.TERRACOTTA_MAGENTA, MapColor.TERRACOTTA_PINK};
    public static final DeferredBlock<Block> GLANCE = OBlocks.register("glance", () -> new Block(OBlocks.glanceProperties()));
    public static final DeferredBlock<Block> POLISHED_GLANCE = OBlocks.register("polished_glance", () -> new Block(OBlocks.glanceProperties()));
    public static final DeferredBlock<Block> GLANCE_BRICKS = OBlocks.register("glance_bricks", () -> new Block(OBlocks.glanceProperties()));
    public static final DeferredBlock<Block> CHISELED_GLANCE = OBlocks.register("chiseled_glance", () -> new Block(OBlocks.glanceProperties()));
    public static final DeferredBlock<SlabBlock> GLANCE_SLAB = OBlocks.register("glance_slab", () -> new SlabBlock(OBlocks.glanceProperties()));
    public static final DeferredBlock<SlabBlock> POLISHED_GLANCE_SLAB = OBlocks.register("polished_glance_slab", () -> new SlabBlock(OBlocks.glanceProperties()));
    public static final DeferredBlock<SlabBlock> GLANCE_BRICK_SLAB = OBlocks.register("glance_brick_slab", () -> new SlabBlock(OBlocks.glanceProperties()));
    public static final DeferredBlock<StairBlock> GLANCE_STAIRS = OBlocks.register("glance_stairs", () -> new StairBlock(((Block)GLANCE.get()).defaultBlockState(), OBlocks.glanceProperties()));
    public static final DeferredBlock<StairBlock> POLISHED_GLANCE_STAIRS = OBlocks.register("polished_glance_stairs", () -> new StairBlock(((Block)POLISHED_GLANCE.get()).defaultBlockState(), OBlocks.glanceProperties()));
    public static final DeferredBlock<StairBlock> GLANCE_BRICK_STAIRS = OBlocks.register("glance_brick_stairs", () -> new StairBlock(((Block)GLANCE_BRICKS.get()).defaultBlockState(), OBlocks.glanceProperties()));
    public static final DeferredBlock<WallBlock> GLANCE_WALL = OBlocks.register("glance_wall", () -> new WallBlock(OBlocks.glanceProperties()));
    public static final DeferredBlock<WallBlock> GLANCE_BRICK_WALL = OBlocks.register("glance_brick_wall", () -> new WallBlock(OBlocks.glanceProperties()));
    public static final DeferredBlock<Block> SPOTTED_GLANCE = OBlocks.register("spotted_glance", () -> new SpottedGlanceBlock(OBlocks.glanceProperties()));
    public static final DeferredBlock<Block> WAXED_SPOTTED_GLANCE = OBlocks.register("waxed_spotted_glance", () -> new Block(OBlocks.glanceProperties()));
    public static final DeferredBlock<Block> SILVER_ORE = OBlocks.register("silver_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_ORE)));
    public static final DeferredBlock<Block> DEEPSLATE_SILVER_ORE = OBlocks.register("deepslate_silver_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_GOLD_ORE)));
    public static final DeferredBlock<Block> LEAD_ORE = OBlocks.register("lead_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_ORE).strength(3.0f, 3.0f)));
    public static final DeferredBlock<Block> DEEPSLATE_LEAD_ORE = OBlocks.register("deepslate_lead_ore", () -> new DropExperienceBlock((IntProvider)ConstantInt.of((int)0), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DEEPSLATE_GOLD_ORE)));
    public static final DeferredBlock<Block> RAW_SILVER_BLOCK = OBlocks.register("raw_silver_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RAW_IRON_BLOCK).mapColor(MapColor.CLAY)));
    public static final DeferredBlock<Block> RAW_LEAD_BLOCK = OBlocks.register("raw_lead_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RAW_IRON_BLOCK).mapColor(LEAD_MAP_COLORS[0])));
    public static final DeferredBlock<Block> SILVER_BLOCK = OBlocks.register("silver_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).strength(5.0f, 6.0f).sound(SoundType.METAL)));
    public static final DeferredBlock<Block> GARGOYLE = OBlocks.register("gargoyle", () -> new GargoyleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).noOcclusion()));
    public static final DeferredBlock<Block> WHITE_DATURA = OBlocks.register("datura", () -> new FlowerBlock(OEffects.STUNNING, 21.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OXEYE_DAISY)));
    public static final DeferredBlock<Block> PURPLE_DATURA = OBlocks.register("purple_datura", () -> new FlowerBlock(OEffects.STUNNING, 21.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ALLIUM)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_WHITE_DATURA = HELPER.createBlockNoItem("potted_datura", () -> new FlowerPotBlock((Block)WHITE_DATURA.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_OXEYE_DAISY)));
    public static final DeferredBlock<FlowerPotBlock> POTTED_PURPLE_DATURA = HELPER.createBlockNoItem("potted_purple_datura", () -> new FlowerPotBlock((Block)PURPLE_DATURA.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ALLIUM)));
    public static final DeferredBlock<Block> LEAD_BOLT_CRATE = OBlocks.register("lead_bolt_crate", () -> new Block(BlockBehaviour.Properties.of().strength(1.5f).sound(SoundType.WOOD)));
    public static final DeferredBlock<MeltableBlock> LEAD_BLOCK = OBlocks.register("lead_block", () -> new MeltableBlock(OBlocks.leadProperties()));
    public static final DeferredBlock<MeltableBlock> LEAD_BRICKS = OBlocks.register("lead_bricks", () -> new MeltableBlock(OBlocks.leadProperties()));
    public static final DeferredBlock<MeltablePillarBlock> CUT_LEAD = OBlocks.register("cut_lead", () -> new MeltablePillarBlock(OBlocks.leadProperties()));
    public static final DeferredBlock<MeltablePillarBlock> LEAD_PILLAR = OBlocks.register("lead_pillar", () -> new MeltablePillarBlock(OBlocks.leadProperties()));
    public static final DeferredBlock<MeltableBlock> LEAD_BULB = OBlocks.register("lead_bulb", () -> new BulbBlock(OBlocks.leadProperties().lightLevel(BulbBlock::getLightLevel)));
    public static final BlockSetType LEAD_BLOCK_SET = BlockSetType.register((BlockSetType)new BlockSetType("lead", true, false, false, BlockSetType.PressurePlateSensitivity.MOBS, SoundType.METAL, SoundEvents.IRON_DOOR_CLOSE, SoundEvents.IRON_DOOR_OPEN, SoundEvents.IRON_TRAPDOOR_CLOSE, SoundEvents.IRON_TRAPDOOR_OPEN, SoundEvents.METAL_PRESSURE_PLATE_CLICK_OFF, SoundEvents.METAL_PRESSURE_PLATE_CLICK_ON, SoundEvents.STONE_BUTTON_CLICK_OFF, SoundEvents.STONE_BUTTON_CLICK_ON));
    public static final DeferredBlock<LeadDoorBlock> LEAD_DOOR = OBlocks.baseRegister("lead_door", () -> new LeadDoorBlock(OBlocks.leadDecoProperties()), block -> () -> new DoubleHighBlockItem((Block)block.get(), new Item.Properties()));
    public static final DeferredBlock<LeadTrapdoorBlock> LEAD_TRAPDOOR = OBlocks.register("lead_trapdoor", () -> new LeadTrapdoorBlock(OBlocks.leadDecoProperties()));
    public static final DeferredBlock<LeadBarsBlock> LEAD_BARS = OBlocks.register("lead_bars", () -> new LeadBarsBlock(OBlocks.leadDecoProperties()));
    public static final DeferredBlock<Block> ELECTRUM_BLOCK = OBlocks.register("electrum_block", () -> new Block(BlockBehaviour.Properties.of().strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL).mapColor(MapColor.SAND)));
    public static final DeferredBlock<Block> SHRAPNEL_BOMB = OBlocks.register("shrapnel_bomb", () -> new ShrapnelBombBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TNT)));
    public static final Map<DyeColor, DeferredBlock<Block>> CRYSTAL_GLASS = OBlocks.registerColored("crystal_glass", (DyeColor dye) -> new CrystalGlassBlock((DyeColor)dye, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_STAINED_GLASS).mapColor(dye)));
    public static final Map<DyeColor, DeferredBlock<Block>> CRYSTAL_GLASS_PANES = OBlocks.registerColored("crystal_glass_pane", (DyeColor dye) -> new CrystalGlassPaneBlock((DyeColor)dye, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_STAINED_GLASS_PANE).mapColor(dye)));
    public static final DeferredBlock<Block> GROOVED_ICE = OBlocks.register("grooved_ice", () -> new IceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ICE).friction(0.6f)));
    public static final DeferredBlock<Block> GROOVED_PACKED_ICE = OBlocks.register("grooved_packed_ice", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.PACKED_ICE).friction(0.6f)));
    public static final DeferredBlock<Block> GROOVED_BLUE_ICE = OBlocks.register("grooved_blue_ice", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BLUE_ICE).friction(0.6f)));
    public static final Map<DyeColor, DeferredBlock<Block>> WAXED_CONCRETE_POWDER = OBlocks.registerColored(color -> "waxed_" + color + "_concrete_powder", (DyeColor dye) -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GREEN_CONCRETE_POWDER).mapColor(dye)));
    public static final DeferredBlock<LiquidBlock> MOLTEN_LEAD = HELPER.createBlockNoItem("molten_lead", () -> new MoltenLeadBlock((Supplier<? extends FlowingFluid>)OFluids.MOLTEN_LEAD, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAVA).mapColor(MapColor.COLOR_PURPLE)));
    public static final DeferredBlock<Block> MOLTEN_LEAD_CAULDRON = HELPER.createBlockNoItem("molten_lead_cauldron", () -> new MoltenLeadCauldronBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LAVA_CAULDRON).randomTicks()));

    private static BlockBehaviour.Properties glanceProperties() {
        return BlockBehaviour.Properties.of().explosionResistance(6.0f).strength(1.5f).mapColor(MapColor.CLAY);
    }

    private static BlockBehaviour.Properties leadProperties() {
        return BlockBehaviour.Properties.of().strength(5.0f, 6.0f).requiresCorrectToolForDrops().sound(SoundType.METAL).lightLevel(IMeltableBlock::getLightLevel).mapColor(OBlocks::leadMapColor).randomTicks();
    }

    private static MapColor leadMapColor(BlockState state) {
        Block block = state.getBlock();
        if (!(block instanceof MeltableBlock)) {
            return LEAD_MAP_COLORS[0];
        }
        MeltableBlock block2 = (MeltableBlock)block;
        int goopyness = Math.min(2, block2.getGoopyness(state));
        return LEAD_MAP_COLORS[goopyness];
    }

    private static BlockBehaviour.Properties leadDecoProperties() {
        return OBlocks.leadProperties().noOcclusion().isValidSpawn(($1, $2, $3, $4) -> false);
    }

    public static <T extends Block> Map<DyeColor, DeferredBlock<T>> registerColored(UnaryOperator<String> nameCreator, Function<DyeColor, ? extends T> factory) {
        return DyeColors.supported().collect(Collectors.toMap(it -> it, color -> OBlocks.register((String)nameCreator.apply(color.getSerializedName()), () -> (Block)factory.apply((DyeColor)color))));
    }

    public static <T extends Block> Map<DyeColor, DeferredBlock<T>> registerColored(String baseName, Function<DyeColor, ? extends T> factory) {
        return OBlocks.registerColored(color -> color + "_" + baseName, factory);
    }

    public static <T extends Block> DeferredBlock<T> baseRegister(String name, Supplier<? extends T> block, Function<DeferredBlock<T>, Supplier<? extends Item>> item) {
        DeferredBlock register = HELPER.createBlockNoItem(name, block);
        OItems.HELPER.createItem(name, item.apply(register));
        return register;
    }

    public static <B extends Block> DeferredBlock<B> register(String name, Supplier<? extends Block> block) {
        return OBlocks.baseRegister(name, block, OBlocks::registerBlockItem);
    }

    private static <T extends Block> Supplier<BlockItem> registerBlockItem(DeferredBlock<T> block) {
        return () -> new BlockItem(Objects.requireNonNull((Block)block.get()), new Item.Properties());
    }

    public static void register() {
    }
}

