/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.mixin;

import galena.oreganized.network.packet.DoorPushingPacket;
import galena.oreganized.world.IDoorProgressHolder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerMixin
implements IDoorProgressHolder {
    @Unique
    private int oreganised$leadDoorOpeningProgress = 0;
    @Unique
    private long oreganised$lastPress = 0L;

    @Override
    @Unique
    public int oreganised$getOpeningProgress() {
        return this.oreganised$leadDoorOpeningProgress;
    }

    @Unique
    private void oreganized$syncProgress(boolean pushing) {
        Player self = (Player)this;
        if (self instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)self;
            DoorPushingPacket packet = new DoorPushingPacket(self.getUUID(), pushing);
            PacketDistributor.sendToPlayersInDimension((ServerLevel)player.serverLevel(), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    @Unique
    public int oreganised$incrementOpeningProgress() {
        Player self = (Player)this;
        this.oreganised$lastPress = self.level().getGameTime();
        this.oreganized$syncProgress(true);
        return ++this.oreganised$leadDoorOpeningProgress;
    }

    @Override
    @Unique
    public void oreganised$resetOpeningProgress() {
        this.oreganised$leadDoorOpeningProgress = 0;
        this.oreganized$syncProgress(false);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void oreganised$onTick(CallbackInfo ci) {
        if (this.oreganised$leadDoorOpeningProgress == 0) {
            return;
        }
        Player self = (Player)this;
        if (self.level() == null || self.level().isClientSide) {
            return;
        }
        long time = self.level().getGameTime();
        if (time - this.oreganised$lastPress > 6L) {
            this.oreganised$resetOpeningProgress();
        }
    }
}

