/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.network.packet;

import galena.oreganized.Oreganized;
import galena.oreganized.world.IDoorProgressHolder;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record DoorPushingPacket(UUID player, boolean pushing) implements CustomPacketPayload
{
    public static final CustomPacketPayload.TypeAndCodec<FriendlyByteBuf, DoorPushingPacket> TYPE = new CustomPacketPayload.TypeAndCodec(new CustomPacketPayload.Type(Oreganized.modLoc("door_pushing")), StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, DoorPushingPacket::player, (StreamCodec)ByteBufCodecs.BOOL, DoorPushingPacket::pushing, DoorPushingPacket::new));

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player().level().getPlayerByUUID(this.player());
            if (player instanceof IDoorProgressHolder) {
                IDoorProgressHolder progressHolder = (IDoorProgressHolder)player;
                if (this.pushing) {
                    progressHolder.oreganised$incrementOpeningProgress();
                } else {
                    progressHolder.oreganised$resetOpeningProgress();
                }
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE.type();
    }
}

