/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.world;

import galena.oreganized.index.OAttributes;
import galena.oreganized.index.OParticleTypes;
import galena.oreganized.network.packet.KineticHitPacket;
import galena.oreganized.world.IMotionHolder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class KineticDamage {
    public static void apply(LivingEntity cause, Entity target) {
        if (!(cause instanceof IMotionHolder)) {
            return;
        }
        IMotionHolder motionHolder = (IMotionHolder)cause;
        double motion = Math.sqrt(motionHolder.oreganised$getHorizontalMotion()) - 0.15;
        double factor = Math.min(motion / 0.12, 1.0);
        if (factor <= 0.0) {
            return;
        }
        if (!cause.getAttributes().hasAttribute(OAttributes.KINETIC_DAMAGE)) {
            return;
        }
        double kineticDamage = factor * cause.getAttributeValue(OAttributes.KINETIC_DAMAGE);
        DamageSource source = target.level().damageSources().generic();
        if (kineticDamage == 0.0) {
            return;
        }
        target.invulnerableTime = 0;
        target.hurt(source, (float)kineticDamage);
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            KineticHitPacket packet = new KineticHitPacket(target.getId(), (float)factor);
            PacketDistributor.sendToPlayersNear((ServerLevel)level2, null, (double)target.getX(), (double)target.getY(), (double)target.getZ(), (double)16.0, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void spawnParticles(Entity target, float factor) {
        Level level = target.level();
        int count = (int)(1.0 + Math.floor(4.0f * factor));
        for (int i = 0; i < count; ++i) {
            level.addParticle((ParticleOptions)OParticleTypes.KINETIC_HIT.get(), target.getRandomX(0.75), target.getRandomY(), target.getRandomZ(0.75), level.random.nextGaussian() * 0.02, level.random.nextGaussian() * 0.02, level.random.nextGaussian() * 0.02);
        }
    }
}

