/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.world.event;

import galena.oreganized.Oreganized;
import galena.oreganized.content.block.MoltenLeadCauldronBlock;
import galena.oreganized.content.item.ScribeItem;
import galena.oreganized.content.item.ThermometerItem;
import galena.oreganized.index.OAttributes;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OItems;
import galena.oreganized.index.OTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockDropsEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="oreganized")
public class PlayerEvents {
    @SubscribeEvent
    public static void blockItemInteractions(PlayerInteractEvent.RightClickBlock event) {
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = world.getBlockState(pos);
        ItemStack itemStack = event.getItemStack();
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        if (itemStack.is(Items.MUSIC_DISC_11) && state.is((Block)OBlocks.MOLTEN_LEAD_CAULDRON.get())) {
            if (!((Integer)state.getValue((Property)MoltenLeadCauldronBlock.AGE)).equals(3)) {
                return;
            }
            ItemStack newDisc = new ItemStack((ItemLike)OItems.MUSIC_DISC_STRUCTURE.get());
            player.swing(hand);
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            world.playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!world.isClientSide()) {
                player.awardStat(Stats.ITEM_USED.get((Object)itemStack.getItem()));
            }
            if (itemStack.isEmpty()) {
                player.setItemInHand(hand, newDisc);
                return;
            }
            if (!player.getInventory().add(newDisc)) {
                player.drop(newDisc, false);
            }
            world.setBlockAndUpdate(pos, Blocks.CAULDRON.defaultBlockState());
        }
    }

    @SubscribeEvent
    public static void tickPlayer(PlayerTickEvent.Post event) {
        CompoundTag data = event.getEntity().getPersistentData();
        if (data.contains("oreganized:gargoyle_use_cooldown", 99)) {
            int cooldown = data.getInt("oreganized:gargoyle_use_cooldown");
            if (cooldown > 0) {
                data.putInt("oreganized:gargoyle_use_cooldown", cooldown - 1);
            } else {
                data.remove("oreganized:gargoyle_use_cooldown");
            }
        }
        ItemStack stack = event.getEntity().getItemInHand(InteractionHand.MAIN_HAND);
        if (event.getEntity().level().getGameTime() % 20L != 0L) {
            return;
        }
        if (stack.is((Item)OItems.THERMOMETER.get()) && !ThermometerItem.isLocked(stack)) {
            int heatLevel = ThermometerItem.ambientMeasurement(event.getEntity());
            ThermometerItem.setHeatLevel(stack, event.getEntity().level(), heatLevel);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockDropsEvent event) {
        ScribeItem scribe;
        ItemStack stack = event.getTool();
        Item item = stack.getItem();
        if (item instanceof ScribeItem && (scribe = (ScribeItem)item).dropsLikeSilktouch(stack, event.getState())) {
            event.setDroppedExperience(0);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onItemAttributes(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.is(OTags.Items.HAS_KINETIC_DAMAGE)) {
            Double damage = event.getModifiers().stream().filter(it -> it.matches(Attributes.ATTACK_DAMAGE, Item.BASE_ATTACK_DAMAGE_ID)).map(it -> it.modifier().amount()).findFirst().orElse(2.0);
            event.addModifier(OAttributes.KINETIC_DAMAGE, new AttributeModifier(Oreganized.modLoc("kinetic_damage"), damage / 3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        }
    }
}

