/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.world.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import galena.oreganized.index.ORecipeTypes;
import galena.oreganized.world.recipe.BlockRecipeInput;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.jetbrains.annotations.Nullable;

public record ScribeRecipe(BlockPredicate from, Block to, boolean dropResources) implements Recipe<BlockRecipeInput>
{
    public boolean matches(BlockRecipeInput input, Level level) {
        return this.from.matches(input.block()) && !input.block().getState().is(this.to);
    }

    public ItemStack assemble(BlockRecipeInput input, HolderLookup.Provider provider) {
        return this.getResultItem(provider);
    }

    public boolean canCraftInDimensions(int height, int width) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.to.asItem().getDefaultInstance();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ORecipeTypes.SCRIBE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ORecipeTypes.SCRIBE_RECIPE.get();
    }

    public static class Builder
    implements RecipeBuilder {
        private BlockPredicate.Builder from;
        private Block to;
        private boolean dropResources = false;
        private Set<ICondition> conditions = new HashSet<ICondition>();

        public Builder unlockedBy(String key, Criterion<?> criterion) {
            return this;
        }

        public Builder group(@Nullable String group) {
            return this;
        }

        public Item getResult() {
            return this.to.asItem();
        }

        public ScribeRecipe build() {
            Objects.requireNonNull(this.from);
            Objects.requireNonNull(this.to);
            return new ScribeRecipe(this.from.build(), this.to, this.dropResources);
        }

        public Builder result(Block block) {
            this.to = block;
            return this;
        }

        public Builder from(BlockPredicate.Builder predicate) {
            this.from = predicate;
            return this;
        }

        public Builder from(Block block) {
            return this.from(BlockPredicate.Builder.block().of(new Block[]{block}));
        }

        public Builder from(TagKey<Block> tag) {
            return this.from(BlockPredicate.Builder.block().of(tag));
        }

        public Builder when(String ... modIds) {
            return this.when((ICondition[])Arrays.stream(modIds).map(ModLoadedCondition::new).toArray(ICondition[]::new));
        }

        public Builder when(ICondition ... conditions) {
            this.conditions.addAll(Arrays.asList(conditions));
            return this;
        }

        public Builder dropResources(boolean value) {
            this.dropResources = value;
            return this;
        }

        public Builder dropResources() {
            return this.dropResources(true);
        }

        public void save(RecipeOutput output, ResourceLocation id) {
            output.accept(id.withPrefix("scribe/"), (Recipe)this.build(), null, (ICondition[])this.conditions.toArray(ICondition[]::new));
        }
    }

    public static class Serializer
    implements RecipeSerializer<ScribeRecipe> {
        public static final MapCodec<ScribeRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BlockPredicate.CODEC.fieldOf("from").forGetter(ScribeRecipe::from), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("to").forGetter(ScribeRecipe::to), (App)Codec.BOOL.optionalFieldOf("drop_resources", (Object)false).forGetter(ScribeRecipe::dropResources)).apply((Applicative)builder, ScribeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ScribeRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPredicate.STREAM_CODEC, ScribeRecipe::from, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.BLOCK), ScribeRecipe::to, (StreamCodec)ByteBufCodecs.BOOL, ScribeRecipe::dropResources, ScribeRecipe::new);

        public MapCodec<ScribeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ScribeRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

