/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.server;

import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.commands.CommandSourceStack;
import org.jetbrains.annotations.NotNull;

public class UtilCommand {
    @NotNull
    public static SuggestionProvider<CommandSourceStack> suggestOnlinePlayers() {
        return (context, builder) -> {
            for (String playerName : ((CommandSourceStack)context.getSource()).getOnlinePlayerNames()) {
                if (!playerName.toLowerCase().startsWith(builder.getRemaining().toLowerCase())) continue;
                builder.suggest(playerName);
            }
            return builder.buildFuture();
        };
    }

    @NotNull
    public static SuggestionProvider<CommandSourceStack> suggestString(@NotNull Collection<String> collection) {
        return (context, builder) -> {
            for (String name : collection) {
                builder.suggest(name);
            }
            return builder.buildFuture();
        };
    }

    @NotNull
    public static SuggestionProvider<CommandSourceStack> suggestAmount(@NotNull Collection<Integer> collection) {
        return (context, builder) -> {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                int amount = (Integer)iterator.next();
                builder.suggest(amount);
            }
            return builder.buildFuture();
        };
    }
}

