/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.client.column;

import com.vecoo.extralib.shade.mariadb.jdbc.Configuration;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ColumnDecoder;
import com.vecoo.extralib.shade.mariadb.jdbc.client.DataType;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ReadableByteBuf;
import com.vecoo.extralib.shade.mariadb.jdbc.client.column.StringColumn;
import com.vecoo.extralib.shade.mariadb.jdbc.util.CharsetEncodingLength;

public class JsonColumn
extends StringColumn
implements ColumnDecoder {
    public JsonColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    protected JsonColumn(JsonColumn prev) {
        super(prev);
    }

    @Override
    public int getDisplaySize() {
        if (this.charset != 63) {
            Integer maxWidth = CharsetEncodingLength.maxCharlen.get(this.charset);
            if (maxWidth != null) {
                return (int)(this.columnLength / (long)maxWidth.intValue());
            }
            return (int)(this.columnLength / 4L);
        }
        return (int)this.columnLength;
    }

    @Override
    public JsonColumn useAliasAsName() {
        return new JsonColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return String.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        return -1;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        return "JSON";
    }
}

