/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.message.client;

import com.vecoo.extralib.shade.mariadb.jdbc.BasePreparedStatement;
import com.vecoo.extralib.shade.mariadb.jdbc.ServerPreparedStatement;
import com.vecoo.extralib.shade.mariadb.jdbc.Statement;
import com.vecoo.extralib.shade.mariadb.jdbc.client.Completion;
import com.vecoo.extralib.shade.mariadb.jdbc.client.Context;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ReadableByteBuf;
import com.vecoo.extralib.shade.mariadb.jdbc.client.socket.Reader;
import com.vecoo.extralib.shade.mariadb.jdbc.client.socket.Writer;
import com.vecoo.extralib.shade.mariadb.jdbc.client.util.ClosableLock;
import com.vecoo.extralib.shade.mariadb.jdbc.export.ExceptionFactory;
import com.vecoo.extralib.shade.mariadb.jdbc.message.ClientMessage;
import com.vecoo.extralib.shade.mariadb.jdbc.message.server.CachedPrepareResultPacket;
import com.vecoo.extralib.shade.mariadb.jdbc.message.server.ErrorPacket;
import com.vecoo.extralib.shade.mariadb.jdbc.message.server.PrepareResultPacket;
import java.io.IOException;
import java.sql.SQLException;
import java.util.function.Consumer;

public final class PreparePacket
implements ClientMessage {
    private final String sql;

    public PreparePacket(String sql) {
        this.sql = sql;
    }

    @Override
    public int encode(Writer writer, Context context) throws IOException {
        writer.initPacket();
        writer.writeByte(22);
        writer.writeString(this.sql);
        writer.flush();
        return 1;
    }

    @Override
    public Completion readPacket(Statement stmt, int fetchSize, long maxRows, int resultSetConcurrency, int resultSetType, boolean closeOnCompletion, Reader reader, Writer writer, Context context, ExceptionFactory exceptionFactory, ClosableLock lock, boolean traceEnable, ClientMessage message, Consumer<String> redirectFct) throws IOException, SQLException {
        ReadableByteBuf buf = reader.readReusablePacket(traceEnable);
        if (buf.getUnsignedByte() == 255) {
            ErrorPacket errorPacket = new ErrorPacket(buf, context);
            throw exceptionFactory.withSql(this.description()).create(errorPacket.getMessage(), errorPacket.getSqlState(), errorPacket.getErrorCode(), true);
        }
        if (context.getConf().useServerPrepStmts() && context.getConf().cachePrepStmts() && this.sql.length() < 8192) {
            CachedPrepareResultPacket prepare = new CachedPrepareResultPacket(buf, reader, context);
            PrepareResultPacket previousCached = (PrepareResultPacket)context.putPrepareCacheCmd(this.sql, prepare, stmt instanceof ServerPreparedStatement ? (ServerPreparedStatement)stmt : null);
            if (stmt != null) {
                ((BasePreparedStatement)stmt).setPrepareResult(previousCached != null ? previousCached : prepare);
            }
            return previousCached != null ? previousCached : prepare;
        }
        PrepareResultPacket prepareResult = new PrepareResultPacket(buf, reader, context);
        if (stmt != null) {
            ((BasePreparedStatement)stmt).setPrepareResult(prepareResult);
        }
        return prepareResult;
    }

    @Override
    public String description() {
        return "PREPARE " + this.sql;
    }
}

