/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj;

import com.vecoo.extralib.shade.mysql.cj.CancelQueryTask;
import com.vecoo.extralib.shade.mysql.cj.CancelQueryTaskImpl;
import com.vecoo.extralib.shade.mysql.cj.NativeQueryAttributesBindings;
import com.vecoo.extralib.shade.mysql.cj.NativeSession;
import com.vecoo.extralib.shade.mysql.cj.Query;
import com.vecoo.extralib.shade.mysql.cj.QueryAttributesBindings;
import com.vecoo.extralib.shade.mysql.cj.conf.PropertyKey;
import com.vecoo.extralib.shade.mysql.cj.conf.RuntimeProperty;
import com.vecoo.extralib.shade.mysql.cj.exceptions.CJException;
import com.vecoo.extralib.shade.mysql.cj.exceptions.CJTimeoutException;
import com.vecoo.extralib.shade.mysql.cj.exceptions.ExceptionFactory;
import com.vecoo.extralib.shade.mysql.cj.exceptions.OperationCancelledException;
import com.vecoo.extralib.shade.mysql.cj.protocol.Message;
import com.vecoo.extralib.shade.mysql.cj.protocol.ProtocolEntityFactory;
import com.vecoo.extralib.shade.mysql.cj.protocol.Resultset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractQuery
implements Query {
    static int statementCounter = 1;
    public NativeSession session = null;
    protected int statementId;
    protected RuntimeProperty<Integer> maxAllowedPacket;
    protected String charEncoding = null;
    protected Lock cancelTimeoutLock = new ReentrantLock();
    private Query.CancelStatus cancelStatus = Query.CancelStatus.NOT_CANCELED;
    protected long timeoutInMillis = 0L;
    protected List<Object> batchedArgs;
    protected Resultset.Type resultSetType = Resultset.Type.FORWARD_ONLY;
    protected int fetchSize = 0;
    protected final AtomicBoolean statementExecuting = new AtomicBoolean(false);
    protected String currentDb = null;
    protected boolean clearWarningsCalled = false;
    private long executeTime = -1L;
    protected QueryAttributesBindings queryAttributesBindings;
    protected final Lock lock = new ReentrantLock();

    public AbstractQuery(NativeSession sess) {
        ++statementCounter;
        this.session = sess;
        this.maxAllowedPacket = sess.getPropertySet().getIntegerProperty(PropertyKey.maxAllowedPacket);
        this.charEncoding = sess.getPropertySet().getStringProperty(PropertyKey.characterEncoding).getValue();
        this.queryAttributesBindings = new NativeQueryAttributesBindings(sess);
    }

    @Override
    public int getId() {
        return this.statementId;
    }

    @Override
    public void setCancelStatus(Query.CancelStatus cs) {
        this.cancelStatus = cs;
    }

    @Override
    public long getExecuteTime() {
        return this.executeTime;
    }

    @Override
    public void setExecuteTime(long executeTime) {
        this.executeTime = executeTime;
    }

    @Override
    public void checkCancelTimeout() {
        this.cancelTimeoutLock.lock();
        try {
            if (this.cancelStatus != Query.CancelStatus.NOT_CANCELED) {
                CJException cause = this.cancelStatus == Query.CancelStatus.CANCELED_BY_TIMEOUT ? new CJTimeoutException() : new OperationCancelledException();
                this.resetCancelledState();
                throw cause;
            }
        }
        finally {
            this.cancelTimeoutLock.unlock();
        }
    }

    @Override
    public void resetCancelledState() {
        this.cancelTimeoutLock.lock();
        try {
            this.cancelStatus = Query.CancelStatus.NOT_CANCELED;
        }
        finally {
            this.cancelTimeoutLock.unlock();
        }
    }

    @Override
    public <T extends Resultset, M extends Message> ProtocolEntityFactory<T, M> getResultSetFactory() {
        return null;
    }

    @Override
    public NativeSession getSession() {
        return this.session;
    }

    @Override
    public Lock getCancelTimeoutLock() {
        return this.cancelTimeoutLock;
    }

    @Override
    public void closeQuery() {
        this.queryAttributesBindings = null;
        this.session = null;
    }

    @Override
    public void addBatch(Object batch) {
        if (this.batchedArgs == null) {
            this.batchedArgs = new ArrayList<Object>();
        }
        this.batchedArgs.add(batch);
    }

    @Override
    public List<Object> getBatchedArgs() {
        return this.batchedArgs == null ? null : Collections.unmodifiableList(this.batchedArgs);
    }

    @Override
    public void clearBatchedArgs() {
        if (this.batchedArgs != null) {
            this.batchedArgs.clear();
        }
    }

    @Override
    public QueryAttributesBindings getQueryAttributesBindings() {
        return this.queryAttributesBindings;
    }

    @Override
    public int getResultFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setResultFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public Resultset.Type getResultType() {
        return this.resultSetType;
    }

    @Override
    public void setResultType(Resultset.Type resultSetType) {
        this.resultSetType = resultSetType;
    }

    @Override
    public long getTimeoutInMillis() {
        return this.timeoutInMillis;
    }

    @Override
    public void setTimeoutInMillis(long timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }

    @Override
    public CancelQueryTask startQueryTimer(Query stmtToCancel, long timeout) {
        if (this.session.getPropertySet().getBooleanProperty(PropertyKey.enableQueryTimeouts).getValue().booleanValue() && timeout != 0L) {
            CancelQueryTaskImpl timeoutTask = new CancelQueryTaskImpl(stmtToCancel);
            this.session.getCancelTimer().schedule((TimerTask)timeoutTask, timeout);
            return timeoutTask;
        }
        return null;
    }

    @Override
    public void stopQueryTimer(CancelQueryTask timeoutTask, boolean rethrowCancelReason, boolean checkCancelTimeout) {
        if (timeoutTask != null) {
            timeoutTask.cancel();
            if (rethrowCancelReason && timeoutTask.getCaughtWhileCancelling() != null) {
                Throwable t2 = timeoutTask.getCaughtWhileCancelling();
                throw ExceptionFactory.createException(t2.getMessage(), t2);
            }
            if (this.session != null) {
                this.session.getCancelTimer().purge();
            }
            if (checkCancelTimeout) {
                this.checkCancelTimeout();
            }
        }
    }

    @Override
    public AtomicBoolean getStatementExecuting() {
        return this.statementExecuting;
    }

    @Override
    public String getCurrentDatabase() {
        return this.currentDb;
    }

    @Override
    public void setCurrentDatabase(String currentDb) {
        this.currentDb = currentDb;
    }

    @Override
    public boolean isClearWarningsCalled() {
        return this.clearWarningsCalled;
    }

    @Override
    public void setClearWarningsCalled(boolean clearWarningsCalled) {
        this.clearWarningsCalled = clearWarningsCalled;
    }

    @Override
    public void statementBegins() {
        this.clearWarningsCalled = false;
        this.statementExecuting.set(true);
    }
}

