/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj.otel;

import com.vecoo.extralib.shade.mysql.cj.otel.OpenTelemetryScope;
import com.vecoo.extralib.shade.mysql.cj.telemetry.TelemetryAttribute;
import com.vecoo.extralib.shade.mysql.cj.telemetry.TelemetryScope;
import com.vecoo.extralib.shade.mysql.cj.telemetry.TelemetrySpan;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import java.util.function.Supplier;

public class OpenTelemetrySpan
implements TelemetrySpan {
    private Span span = null;
    private OpenTelemetryScope scope = null;

    public OpenTelemetrySpan(Span span) {
        this.span = span;
    }

    @Override
    public TelemetryScope makeCurrent() {
        this.scope = new OpenTelemetryScope(this.span.makeCurrent());
        return this.scope;
    }

    @Override
    public void setAttribute(TelemetryAttribute key, String value) {
        this.span.setAttribute(key.getKey(), value);
    }

    @Override
    public void setAttribute(TelemetryAttribute key, long value) {
        this.span.setAttribute(key.getKey(), value);
    }

    @Override
    public <T> void setAttribute(TelemetryAttribute key, Supplier<T> valueSupplier) {
        T value = valueSupplier.get();
        if (String.class.isInstance(value)) {
            this.setAttribute(key, (String)String.class.cast(value));
        } else if (Long.class.isInstance(value)) {
            this.setAttribute(key, (Long)Long.class.cast(value));
        } else {
            this.setAttribute(key, value == null ? null : value.toString());
        }
    }

    @Override
    public void setError(Throwable cause) {
        this.span.setStatus(StatusCode.ERROR, cause.getMessage()).recordException(cause);
    }

    @Override
    public void end() {
        this.span.end();
    }

    @Override
    public void close() {
        if (this.scope != null) {
            this.scope.close();
            this.scope = null;
        }
        this.end();
    }
}

