/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj.result;

import com.vecoo.extralib.shade.mysql.cj.Messages;
import com.vecoo.extralib.shade.mysql.cj.MysqlType;
import com.vecoo.extralib.shade.mysql.cj.conf.PropertySet;
import com.vecoo.extralib.shade.mysql.cj.exceptions.DataConversionException;
import com.vecoo.extralib.shade.mysql.cj.result.DefaultValueFactory;
import com.vecoo.extralib.shade.mysql.cj.result.Field;
import com.vecoo.extralib.shade.mysql.cj.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.UUID;

public class UuidValueFactory
extends DefaultValueFactory<UUID> {
    public UuidValueFactory(PropertySet pset) {
        super(pset);
    }

    @Override
    public UUID createFromBytes(byte[] bytes, int offset, int length, Field f) {
        if (f.isBinary()) {
            return this.getUuidFromBytes(bytes);
        }
        MysqlType mysqlType = f.getMysqlType();
        switch (mysqlType) {
            case CHAR: 
            case VARCHAR: 
            case TEXT: 
            case TINYTEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: {
                String s2 = StringUtils.toString(bytes, offset, length, f.getEncoding());
                try {
                    return UUID.fromString(s2);
                }
                catch (IllegalArgumentException e) {
                    throw new DataConversionException(Messages.getString("ResultSet.UnableToConvertString", new Object[]{s2, this.getTargetTypeName()}));
                }
            }
        }
        throw new DataConversionException(Messages.getString("ResultSet.UnsupportedConversion", new Object[]{mysqlType.name(), this.getTargetTypeName()}));
    }

    @Override
    public String getTargetTypeName() {
        return UUID.class.getName();
    }

    private UUID getUuidFromBytes(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        long high = bb.getLong();
        long low = bb.getLong();
        return new UUID(high, low);
    }
}

