/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.replication.fluent;

import com.vecoo.extralib.shade.checkerframework.checker.nullness.qual.Nullable;
import com.vecoo.extralib.shade.postgresql.replication.LogSequenceNumber;
import com.vecoo.extralib.shade.postgresql.replication.fluent.ChainedCommonStreamBuilder;
import java.util.concurrent.TimeUnit;

public abstract class AbstractStreamBuilder<T extends ChainedCommonStreamBuilder<T>>
implements ChainedCommonStreamBuilder<T> {
    private static final int DEFAULT_STATUS_INTERVAL = (int)TimeUnit.SECONDS.toMillis(10L);
    protected int statusIntervalMs = DEFAULT_STATUS_INTERVAL;
    protected LogSequenceNumber startPosition = LogSequenceNumber.INVALID_LSN;
    protected @Nullable String slotName;
    protected boolean automaticFlush = true;

    protected abstract T self();

    @Override
    public T withStatusInterval(int time, TimeUnit format) {
        this.statusIntervalMs = (int)TimeUnit.MILLISECONDS.convert(time, format);
        return this.self();
    }

    @Override
    public T withStartPosition(LogSequenceNumber lsn) {
        this.startPosition = lsn;
        return this.self();
    }

    @Override
    public T withSlotName(String slotName) {
        this.slotName = slotName;
        return this.self();
    }

    @Override
    public T withAutomaticFlush(boolean automaticFlush) {
        this.automaticFlush = automaticFlush;
        return this.self();
    }
}

