/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.replication.fluent;

import com.vecoo.extralib.shade.postgresql.core.BaseConnection;
import com.vecoo.extralib.shade.postgresql.core.ReplicationProtocol;
import com.vecoo.extralib.shade.postgresql.replication.PGReplicationStream;
import com.vecoo.extralib.shade.postgresql.replication.fluent.ChainedStreamBuilder;
import com.vecoo.extralib.shade.postgresql.replication.fluent.logical.ChainedLogicalStreamBuilder;
import com.vecoo.extralib.shade.postgresql.replication.fluent.logical.LogicalReplicationOptions;
import com.vecoo.extralib.shade.postgresql.replication.fluent.logical.LogicalStreamBuilder;
import com.vecoo.extralib.shade.postgresql.replication.fluent.logical.StartLogicalReplicationCallback;
import com.vecoo.extralib.shade.postgresql.replication.fluent.physical.ChainedPhysicalStreamBuilder;
import com.vecoo.extralib.shade.postgresql.replication.fluent.physical.PhysicalReplicationOptions;
import com.vecoo.extralib.shade.postgresql.replication.fluent.physical.PhysicalStreamBuilder;
import com.vecoo.extralib.shade.postgresql.replication.fluent.physical.StartPhysicalReplicationCallback;
import java.sql.SQLException;

public class ReplicationStreamBuilder
implements ChainedStreamBuilder {
    private final BaseConnection baseConnection;

    public ReplicationStreamBuilder(BaseConnection connection) {
        this.baseConnection = connection;
    }

    @Override
    public ChainedLogicalStreamBuilder logical() {
        return new LogicalStreamBuilder(new StartLogicalReplicationCallback(){

            @Override
            public PGReplicationStream start(LogicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startLogical(options);
            }
        });
    }

    @Override
    public ChainedPhysicalStreamBuilder physical() {
        return new PhysicalStreamBuilder(new StartPhysicalReplicationCallback(){

            @Override
            public PGReplicationStream start(PhysicalReplicationOptions options) throws SQLException {
                ReplicationProtocol protocol = ReplicationStreamBuilder.this.baseConnection.getReplicationProtocol();
                return protocol.startPhysical(options);
            }
        });
    }
}

