/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.postgresql.shaded.com.ongres.scram.common.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.jetbrains.annotations.NotNull;

public final class TlsServerEndpoint {
    public static final String TLS_SERVER_END_POINT = "tls-server-end-point";

    private TlsServerEndpoint() {
        throw new IllegalStateException("Utility class");
    }

    private static MessageDigest getDigestAlgorithm(String signatureAlgorithm) {
        String algorithm;
        int index = signatureAlgorithm.indexOf("with");
        String string = algorithm = index > 0 ? signatureAlgorithm.substring(0, index) : "SHA-256";
        if (!algorithm.startsWith("SHA3-")) {
            algorithm = algorithm.replace("SHA", "SHA-");
        }
        if ("MD5".equals(algorithm) || "SHA-1".equals(algorithm)) {
            algorithm = "SHA-256";
        }
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }

    public static byte @NotNull [] getChannelBindingData(@NotNull X509Certificate serverCert) throws CertificateEncodingException {
        MessageDigest digestAlgorithm = TlsServerEndpoint.getDigestAlgorithm(serverCert.getSigAlgName());
        if (digestAlgorithm == null) {
            return new byte[0];
        }
        return digestAlgorithm.digest(serverCert.getEncoded());
    }
}

