/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.plugin.codec;

import com.vecoo.extralib.shade.mariadb.jdbc.client.ColumnDecoder;
import com.vecoo.extralib.shade.mariadb.jdbc.client.Context;
import com.vecoo.extralib.shade.mariadb.jdbc.client.DataType;
import com.vecoo.extralib.shade.mariadb.jdbc.client.ReadableByteBuf;
import com.vecoo.extralib.shade.mariadb.jdbc.client.socket.Writer;
import com.vecoo.extralib.shade.mariadb.jdbc.client.util.MutableInt;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.Codec;
import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import java.util.UUID;

public class UuidCodec
implements Codec<UUID> {
    public static final UuidCodec INSTANCE = new UuidCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.VARCHAR, DataType.VARSTRING, DataType.STRING);

    @Override
    public String className() {
        return UUID.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(UUID.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof UUID;
    }

    @Override
    public UUID decodeText(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return UUID.fromString(column.decodeStringText(buf, length, cal, context));
    }

    @Override
    public UUID decodeBinary(ReadableByteBuf buf, MutableInt length, ColumnDecoder column, Calendar cal, Context context) throws SQLDataException {
        return UUID.fromString(column.decodeStringBinary(buf, length, cal, context));
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLen) throws IOException {
        encoder.writeByte(39);
        encoder.writeAscii(value.toString());
        encoder.writeByte(39);
    }

    @Override
    public int getApproximateTextProtocolLength(Object value, Long length) {
        return value.toString().length() + 2;
    }

    @Override
    public void encodeBinary(Writer writer, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        String valueSt = value.toString();
        writer.writeLength(valueSt.length());
        writer.writeAscii(valueSt);
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.VARSTRING.get();
    }
}

