/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj.result;

import com.vecoo.extralib.shade.mysql.cj.Constants;
import com.vecoo.extralib.shade.mysql.cj.Messages;
import com.vecoo.extralib.shade.mysql.cj.conf.PropertyKey;
import com.vecoo.extralib.shade.mysql.cj.conf.PropertySet;
import com.vecoo.extralib.shade.mysql.cj.exceptions.DataConversionException;
import com.vecoo.extralib.shade.mysql.cj.protocol.a.MysqlTextValueDecoder;
import com.vecoo.extralib.shade.mysql.cj.result.DefaultValueFactory;
import com.vecoo.extralib.shade.mysql.cj.result.Field;
import com.vecoo.extralib.shade.mysql.cj.util.DataTypeUtil;
import com.vecoo.extralib.shade.mysql.cj.util.StringUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;

public class BooleanValueFactory
extends DefaultValueFactory<Boolean> {
    public static final Pattern FLOATING_POINT_PTRN = Pattern.compile("-?\\d*\\.\\d*");
    public static final Pattern INTEGER_PTRN = Pattern.compile("-?\\d+");

    public BooleanValueFactory(PropertySet pset) {
        super(pset);
    }

    @Override
    public Boolean createFromYear(long l) {
        return this.createFromLong(l);
    }

    @Override
    public Boolean createFromLong(long l) {
        return l == -1L || l > 0L;
    }

    @Override
    public Boolean createFromBigInteger(BigInteger i) {
        return i.compareTo(Constants.BIG_INTEGER_ZERO) > 0 || i.compareTo(Constants.BIG_INTEGER_NEGATIVE_ONE) == 0;
    }

    @Override
    public Boolean createFromDouble(double d) {
        return d > 0.0 || d == -1.0;
    }

    @Override
    public Boolean createFromBigDecimal(BigDecimal d) {
        return d.compareTo(Constants.BIG_DECIMAL_ZERO) > 0 || d.compareTo(Constants.BIG_DECIMAL_NEGATIVE_ONE) == 0;
    }

    @Override
    public Boolean createFromBit(byte[] bytes, int offset, int length) {
        return this.createFromLong(DataTypeUtil.bitToLong(bytes, offset, length));
    }

    @Override
    public Boolean createFromBytes(byte[] bytes, int offset, int length, Field f) {
        if (length == 0 && this.pset.getBooleanProperty(PropertyKey.emptyStringsConvertToZero).getValue().booleanValue()) {
            return this.createFromLong(0L);
        }
        String s2 = StringUtils.toString(bytes, offset, length, f.getEncoding());
        byte[] newBytes = s2.getBytes();
        if (s2.equalsIgnoreCase("Y") || s2.equalsIgnoreCase("yes") || s2.equalsIgnoreCase("T") || s2.equalsIgnoreCase("true")) {
            return this.createFromLong(1L);
        }
        if (s2.equalsIgnoreCase("N") || s2.equalsIgnoreCase("no") || s2.equalsIgnoreCase("F") || s2.equalsIgnoreCase("false")) {
            return this.createFromLong(0L);
        }
        if (s2.contains("e") || s2.contains("E") || FLOATING_POINT_PTRN.matcher(s2).matches()) {
            return this.createFromDouble(MysqlTextValueDecoder.getDouble(newBytes, 0, newBytes.length));
        }
        if (INTEGER_PTRN.matcher(s2).matches()) {
            if (s2.charAt(0) == '-' || length <= 19 && newBytes[0] >= 48 && newBytes[0] <= 56) {
                return this.createFromLong(MysqlTextValueDecoder.getLong(newBytes, 0, newBytes.length));
            }
            return this.createFromBigInteger(MysqlTextValueDecoder.getBigInteger(newBytes, 0, newBytes.length));
        }
        throw new DataConversionException(Messages.getString("ResultSet.UnableToInterpretString", new Object[]{s2}));
    }

    @Override
    public String getTargetTypeName() {
        return Boolean.class.getName();
    }
}

