/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mariadb.jdbc.plugin.authentication.standard.ed25519.spec;

import com.vecoo.extralib.shade.mariadb.jdbc.plugin.authentication.standard.ed25519.math.Curve;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.authentication.standard.ed25519.math.GroupElement;
import com.vecoo.extralib.shade.mariadb.jdbc.plugin.authentication.standard.ed25519.math.ScalarOps;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;

public class EdDSAParameterSpec
implements AlgorithmParameterSpec,
Serializable {
    private static final long serialVersionUID = 8274987108472012L;
    private final Curve curve;
    private final String hashAlgo;
    private final ScalarOps sc;
    private final GroupElement B;

    public EdDSAParameterSpec(Curve curve, String hashAlgo, ScalarOps sc, GroupElement B) {
        try {
            MessageDigest hash = MessageDigest.getInstance(hashAlgo);
            if (curve.getField().getb() / 4 != hash.getDigestLength()) {
                throw new IllegalArgumentException("Hash output is not 2b-bit");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Unsupported hash algorithm");
        }
        this.curve = curve;
        this.hashAlgo = hashAlgo;
        this.sc = sc;
        this.B = B;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public String getHashAlgorithm() {
        return this.hashAlgo;
    }

    public ScalarOps getScalarOps() {
        return this.sc;
    }

    public GroupElement getB() {
        return this.B;
    }

    public int hashCode() {
        return this.hashAlgo.hashCode() ^ this.curve.hashCode() ^ this.B.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EdDSAParameterSpec)) {
            return false;
        }
        EdDSAParameterSpec s2 = (EdDSAParameterSpec)o;
        return this.hashAlgo.equals(s2.getHashAlgorithm()) && this.curve.equals(s2.getCurve()) && this.B.equals(s2.getB());
    }
}

