/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.shade.mysql.cj.jdbc.ha;

import com.vecoo.extralib.shade.mysql.cj.conf.ConnectionUrl;
import com.vecoo.extralib.shade.mysql.cj.conf.HostInfo;
import com.vecoo.extralib.shade.mysql.cj.conf.PropertyKey;
import com.vecoo.extralib.shade.mysql.cj.conf.RuntimeProperty;
import com.vecoo.extralib.shade.mysql.cj.jdbc.CloseOption;
import com.vecoo.extralib.shade.mysql.cj.jdbc.ConnectionImpl;
import com.vecoo.extralib.shade.mysql.cj.jdbc.JdbcConnection;
import com.vecoo.extralib.shade.mysql.cj.jdbc.ha.MultiHostMySQLConnection;
import com.vecoo.extralib.shade.mysql.cj.util.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class MultiHostConnectionProxy
implements InvocationHandler {
    private static final String METHOD_GET_MULTI_HOST_SAFE_PROXY = "getMultiHostSafeProxy";
    private static final String METHOD_EQUALS = "equals";
    private static final String METHOD_CLOSE = "close";
    private static final String METHOD_ABORT_INTERNAL = "abortInternal";
    private static final String METHOD_ABORT = "abort";
    private static final String METHOD_IS_CLOSED = "isClosed";
    private static final String METHOD_GET_AUTO_COMMIT = "getAutoCommit";
    private static final String METHOD_GET_CATALOG = "getCatalog";
    private static final String METHOD_GET_SCHEMA = "getSchema";
    private static final String METHOD_GET_DATABASE = "getDatabase";
    private static final String METHOD_GET_TRANSACTION_ISOLATION = "getTransactionIsolation";
    private static final String METHOD_GET_SESSION_MAX_ROWS = "getSessionMaxRows";
    List<HostInfo> hostsList;
    protected ConnectionUrl connectionUrl;
    boolean autoReconnect = false;
    JdbcConnection thisAsConnection = null;
    JdbcConnection parentProxyConnection = null;
    JdbcConnection topProxyConnection = null;
    JdbcConnection currentConnection = null;
    boolean isClosed = false;
    boolean closedExplicitly = false;
    String closedReason = null;
    protected Throwable lastExceptionDealtWith = null;
    private final Lock lock = new ReentrantLock();

    public Lock getLock() {
        return this.lock;
    }

    MultiHostConnectionProxy() throws SQLException {
        this.thisAsConnection = this.getNewWrapperForThisAsConnection();
    }

    MultiHostConnectionProxy(ConnectionUrl connectionUrl) throws SQLException {
        this();
        this.initializeHostsSpecs(connectionUrl, connectionUrl.getHostsList());
    }

    int initializeHostsSpecs(ConnectionUrl connUrl, List<HostInfo> hosts) {
        this.connectionUrl = connUrl;
        Properties props = connUrl.getConnectionArgumentsAsProperties();
        this.autoReconnect = "true".equalsIgnoreCase(props.getProperty(PropertyKey.autoReconnect.getKeyName())) || "true".equalsIgnoreCase(props.getProperty(PropertyKey.autoReconnectForPools.getKeyName()));
        this.hostsList = new ArrayList<HostInfo>(hosts);
        int numHosts = this.hostsList.size();
        return numHosts;
    }

    protected JdbcConnection getProxy() {
        return this.topProxyConnection != null ? this.topProxyConnection : this.thisAsConnection;
    }

    protected JdbcConnection getParentProxy() {
        return this.parentProxyConnection;
    }

    protected final void setProxy(JdbcConnection proxyConn) {
        if (this.parentProxyConnection == null) {
            this.parentProxyConnection = proxyConn;
        }
        this.topProxyConnection = proxyConn;
        this.propagateProxyDown(proxyConn);
    }

    protected void propagateProxyDown(JdbcConnection proxyConn) {
        this.currentConnection.setProxy(proxyConn);
    }

    JdbcConnection getNewWrapperForThisAsConnection() throws SQLException {
        return new MultiHostMySQLConnection(this);
    }

    Object proxyIfReturnTypeIsJdbcInterface(Class<?> returnType, Object toProxy) {
        if (toProxy != null && Util.isJdbcInterface(returnType)) {
            Class<?> toProxyClass = toProxy.getClass();
            return Proxy.newProxyInstance(toProxyClass.getClassLoader(), Util.getImplementedInterfaces(toProxyClass), this.getNewJdbcInterfaceProxy(toProxy));
        }
        return toProxy;
    }

    InvocationHandler getNewJdbcInterfaceProxy(Object toProxy) {
        return new JdbcInterfaceProxy(toProxy);
    }

    void dealWithInvocationException(InvocationTargetException e) throws SQLException, Throwable, InvocationTargetException {
        Throwable t2 = e.getTargetException();
        if (t2 != null) {
            if (this.lastExceptionDealtWith != t2 && this.shouldExceptionTriggerConnectionSwitch(t2)) {
                this.invalidateCurrentConnection();
                this.pickNewConnection();
                this.lastExceptionDealtWith = t2;
            }
            throw t2;
        }
        throw e;
    }

    abstract boolean shouldExceptionTriggerConnectionSwitch(Throwable var1);

    abstract boolean isSourceConnection();

    void invalidateCurrentConnection() throws SQLException {
        this.lock.lock();
        try {
            this.invalidateConnection(this.currentConnection);
        }
        finally {
            this.lock.unlock();
        }
    }

    void invalidateConnection(JdbcConnection conn) throws SQLException {
        this.lock.lock();
        try {
            if (conn != null && !conn.isClosed()) {
                conn.doClose(null, CloseOption.IMPLICIT, CloseOption.ROLLBACK, CloseOption.FORCED);
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    abstract void pickNewConnection() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionImpl createConnectionForHost(HostInfo hostInfo) throws SQLException {
        this.lock.lock();
        try {
            ConnectionImpl conn = (ConnectionImpl)ConnectionImpl.getInstance(hostInfo);
            JdbcConnection topmostProxy = this.getProxy();
            if (topmostProxy != this.thisAsConnection) {
                conn.setProxy(this.thisAsConnection);
            }
            conn.setProxy(topmostProxy);
            ConnectionImpl connectionImpl = conn;
            return connectionImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void syncSessionState(JdbcConnection source, JdbcConnection target) throws SQLException {
        if (source == null || target == null) {
            return;
        }
        RuntimeProperty<Boolean> sourceUseLocalSessionState = source.getPropertySet().getBooleanProperty(PropertyKey.useLocalSessionState);
        boolean prevUseLocalSessionState = sourceUseLocalSessionState.getValue();
        sourceUseLocalSessionState.setValue(true);
        boolean readOnly = source.isReadOnly();
        sourceUseLocalSessionState.setValue(prevUseLocalSessionState);
        this.syncSessionState(source, target, readOnly);
    }

    void syncSessionState(JdbcConnection source, JdbcConnection target, boolean readOnly) throws SQLException {
        if (target != null) {
            target.setReadOnly(readOnly);
        }
        if (source == null || target == null) {
            return;
        }
        RuntimeProperty<Boolean> sourceUseLocalSessionState = source.getPropertySet().getBooleanProperty(PropertyKey.useLocalSessionState);
        boolean prevUseLocalSessionState = sourceUseLocalSessionState.getValue();
        sourceUseLocalSessionState.setValue(true);
        target.setAutoCommit(source.getAutoCommit());
        String db = source.getDatabase();
        if (db != null && !db.isEmpty()) {
            target.setDatabase(db);
        }
        target.setTransactionIsolation(source.getTransactionIsolation());
        target.setSessionMaxRows(source.getSessionMaxRows());
        sourceUseLocalSessionState.setValue(prevUseLocalSessionState);
    }

    abstract void doClose() throws SQLException;

    abstract void doAbortInternal() throws SQLException;

    abstract void doAbort(Executor var1) throws SQLException;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (METHOD_GET_MULTI_HOST_SAFE_PROXY.equals(methodName)) {
            return this.thisAsConnection;
        }
        if (METHOD_EQUALS.equals(methodName)) {
            return args[0].equals(this);
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            return method.invoke((Object)this, args);
        }
        this.lock.lock();
        try {
            if (METHOD_CLOSE.equals(methodName)) {
                this.doClose();
                this.isClosed = true;
                this.closedReason = "Connection explicitly closed.";
                this.closedExplicitly = true;
                Object var5_5 = null;
                return var5_5;
            }
            if (METHOD_ABORT_INTERNAL.equals(methodName)) {
                this.doAbortInternal();
                this.currentConnection.abortInternal();
                this.isClosed = true;
                this.closedReason = "Connection explicitly closed.";
                Object var5_6 = null;
                return var5_6;
            }
            if (METHOD_ABORT.equals(methodName) && args.length == 1) {
                this.doAbort((Executor)args[0]);
                this.isClosed = true;
                this.closedReason = "Connection explicitly closed.";
                Object var5_7 = null;
                return var5_7;
            }
            if (METHOD_IS_CLOSED.equals(methodName)) {
                Boolean bl = this.isClosed;
                return bl;
            }
            Object object = this.invokeMore(proxy, method, args);
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    abstract Object invokeMore(Object var1, Method var2, Object[] var3) throws Throwable;

    protected boolean allowedOnClosedConnection(Method method) {
        String methodName = method.getName();
        return methodName.equals(METHOD_GET_AUTO_COMMIT) || methodName.equals(METHOD_GET_CATALOG) || methodName.equals(METHOD_GET_SCHEMA) || methodName.equals(METHOD_GET_DATABASE) || methodName.equals(METHOD_GET_TRANSACTION_ISOLATION) || methodName.equals(METHOD_GET_SESSION_MAX_ROWS);
    }

    class JdbcInterfaceProxy
    implements InvocationHandler {
        Object invokeOn = null;

        JdbcInterfaceProxy(Object toInvokeOn) {
            this.invokeOn = toInvokeOn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (MultiHostConnectionProxy.METHOD_EQUALS.equals(method.getName())) {
                return args[0].equals(this);
            }
            MultiHostConnectionProxy.this.getLock().lock();
            try {
                Object result = null;
                try {
                    result = method.invoke(this.invokeOn, args);
                    result = MultiHostConnectionProxy.this.proxyIfReturnTypeIsJdbcInterface(method.getReturnType(), result);
                }
                catch (InvocationTargetException e) {
                    MultiHostConnectionProxy.this.dealWithInvocationException(e);
                }
                Object object = result;
                return object;
            }
            finally {
                MultiHostConnectionProxy.this.getLock().unlock();
            }
        }
    }
}

