/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.permission;

import com.mojang.authlib.GameProfile;
import com.vecoo.extralib.ExtraLib;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.Context;
import net.minecraftforge.server.permission.context.IContext;

public class UtilPermission {
    public static boolean hasPermission(@Nonnull ICommandSender source, @Nonnull String node) {
        if (!(source instanceof EntityPlayer)) {
            return true;
        }
        if (PermissionAPI.getPermissionHandler().getRegisteredNodes().contains(node)) {
            return PermissionAPI.hasPermission((EntityPlayer)((EntityPlayer)source), (String)node) || source.func_70003_b(4, node);
        }
        ExtraLib.getLogger().error("No permission found for node: " + node);
        return false;
    }

    public static boolean hasPermission(@Nonnull EntityPlayer player, @Nonnull String node) {
        if (PermissionAPI.getPermissionHandler().getRegisteredNodes().contains(node)) {
            return PermissionAPI.hasPermission((EntityPlayer)player, (String)node) || player.func_70003_b(4, node);
        }
        ExtraLib.getLogger().error("No permission found for node: " + node);
        return false;
    }

    public static boolean hasPermission(@Nonnull UUID playerUUID, @Nonnull String playerName, @Nonnull String node) {
        if (PermissionAPI.getPermissionHandler().getRegisteredNodes().contains(node)) {
            return PermissionAPI.hasPermission((GameProfile)new GameProfile(playerUUID, playerName), (String)node, (IContext)new Context());
        }
        ExtraLib.getLogger().error("No permission found for node: " + node);
        return false;
    }

    public static int minValue(int value, @Nonnull EntityPlayer player, @Nonnull Set<String> permissionList) {
        for (String permission : permissionList) {
            if (!UtilPermission.hasPermission(player, permission)) continue;
            value = Math.min(value, Integer.parseInt(permission.substring(permission.lastIndexOf(46) + 1)));
        }
        return value;
    }

    public static int maxValue(int value, @Nonnull EntityPlayer player, @Nonnull Set<String> permissionList) {
        for (String permission : permissionList) {
            if (!UtilPermission.hasPermission(player, permission)) continue;
            value = Math.max(value, Integer.parseInt(permission.substring(permission.lastIndexOf(46) + 1)));
        }
        return value;
    }

    public static int minValue(int value, @Nonnull UUID playerUUID, @Nonnull String playerName, @Nonnull Set<String> permissionList) {
        for (String permission : permissionList) {
            if (!UtilPermission.hasPermission(playerUUID, playerName, permission)) continue;
            value = Math.min(value, Integer.parseInt(permission.substring(permission.lastIndexOf(46) + 1)));
        }
        return value;
    }

    public static int maxValue(int value, @Nonnull UUID playerUUID, @Nonnull String playerName, @Nonnull Set<String> permissionList) {
        for (String permission : permissionList) {
            if (!UtilPermission.hasPermission(playerUUID, playerName, permission)) continue;
            value = Math.max(value, Integer.parseInt(permission.substring(permission.lastIndexOf(46) + 1)));
        }
        return value;
    }
}

