/*
 * Decompiled with CFR 0.152.
 */
package com.vecoo.extralib.player;

import com.vecoo.extralib.ExtraLib;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.UsernameCache;

public class UtilPlayer {
    @Nullable
    public static UUID getUUID(@Nonnull String playerName) {
        return UsernameCache.getMap().entrySet().stream().filter(entry -> ((String)entry.getValue()).equalsIgnoreCase(playerName)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public static boolean hasUUID(@Nonnull String playerName) {
        return UtilPlayer.getUUID(playerName) != null;
    }

    @Nonnull
    public static String getPlayerName(@Nonnull UUID playerUUID) {
        String name = UsernameCache.getLastKnownUsername((UUID)playerUUID);
        return name != null ? name : "Unknown";
    }

    public static void sendMessageUuid(@Nonnull UUID playerUUID, @Nonnull TextComponentString message) {
        ExtraLib.getInstance().getServer().func_184103_al().func_177451_a(playerUUID).func_145747_a((ITextComponent)message);
    }

    public static void sendMessageUuid(@Nonnull UUID playerUUID, @Nonnull ITextComponent message) {
        ExtraLib.getInstance().getServer().func_184103_al().func_177451_a(playerUUID).func_145747_a(message);
    }

    @Nullable
    public static EntityPlayerMP getPlayer(@Nonnull String playerName) {
        return ExtraLib.getInstance().getServer().func_184103_al().func_152612_a(playerName);
    }

    @Nonnull
    public static ICommandSender getSource(@Nonnull String sourceName) {
        MinecraftServer server = ExtraLib.getInstance().getServer();
        EntityPlayerMP player = server.func_184103_al().func_152612_a(sourceName);
        return player != null ? player.func_174793_f() : server;
    }

    public static int countItemStack(@Nonnull EntityPlayerMP player, @Nonnull ItemStack searchItemStack) {
        int count = 0;
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != searchItemStack.func_77973_b() || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)searchItemStack)) continue;
            count += itemStack.func_190916_E();
        }
        return count;
    }

    public static int countItemStackTag(@Nonnull EntityPlayerMP player, @Nonnull ItemStack searchItemStack, @Nonnull String tag) {
        int count = 0;
        for (ItemStack itemStack : player.field_71071_by.field_70462_a) {
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != searchItemStack.func_77973_b()) continue;
            if (itemStack.func_77978_p() == null && searchItemStack.func_77978_p() == null) {
                count += itemStack.func_190916_E();
                continue;
            }
            if (itemStack.func_77978_p() == null || searchItemStack.func_77978_p() == null || !Objects.equals(itemStack.func_77978_p().func_74775_l(tag), searchItemStack.func_77978_p().func_74775_l(tag))) continue;
            count += itemStack.func_190916_E();
        }
        return count;
    }

    public static void removeItemStack(@Nonnull EntityPlayerMP player, @Nonnull ItemStack removeItemStack, int amount) {
        int totalRemoved = 0;
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        for (ItemStack itemStack : inventoryPlayer.field_70462_a) {
            if (totalRemoved >= amount) break;
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != removeItemStack.func_77973_b() || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)removeItemStack)) continue;
            int toRemove = Math.min(itemStack.func_190916_E(), amount - totalRemoved);
            itemStack.func_190918_g(toRemove);
            totalRemoved += toRemove;
        }
        inventoryPlayer.func_70296_d();
        player.func_71120_a(player.field_71069_bz);
    }

    public static void removeItemStackTag(@Nonnull EntityPlayerMP player, @Nonnull ItemStack removeItemStack, @Nonnull String tag, int amount) {
        int totalRemoved = 0;
        InventoryPlayer inventoryPlayer = player.field_71071_by;
        for (ItemStack itemStack : inventoryPlayer.field_70462_a) {
            if (totalRemoved >= amount) break;
            if (itemStack.func_190926_b() || itemStack.func_77973_b() != removeItemStack.func_77973_b()) continue;
            int toRemove = Math.min(itemStack.func_190916_E(), amount - totalRemoved);
            if (itemStack.func_77978_p() == null && removeItemStack.func_77978_p() == null) {
                itemStack.func_190918_g(toRemove);
                totalRemoved += toRemove;
                continue;
            }
            if (itemStack.func_77978_p() == null || removeItemStack.func_77978_p() == null || !Objects.equals(itemStack.func_77978_p().func_74775_l(tag), removeItemStack.func_77978_p().func_74775_l(tag))) continue;
            itemStack.func_190918_g(toRemove);
            totalRemoved += toRemove;
        }
        inventoryPlayer.func_70296_d();
        player.func_71120_a(player.field_71069_bz);
    }

    public static boolean hasFreeSlot(@Nullable EntityPlayerMP player) {
        if (player == null || player.field_71071_by == null) {
            return false;
        }
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }
}

